/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.type.impl
 * t@C  (file name)    FShortType.java
 */
package net.sf.thirdi.jdbc.type.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import net.sf.thirdi.jdbc.type.AbstractType;

/**
 * <i>Tv(abstract)</i>F Character킷NXłB
 *@.<p>
 * Character킷NXłB
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class CharacterType extends AbstractType{
	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.AbstractType#getResultsetData(java.sql.ResultSet, java.lang.String)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, String columnName) throws SQLException{
		
		String value = rs.getString(columnName);;
	    if(value == null) return null;
	        
	    char chars[] = value.toCharArray();
	        
	    if(chars.length == 1){
	    	 return new Character(chars[0]);
	    } else if(chars.length == 0) {
	        return null;
	    } else {
	    	//TODO message move to property file.
	    	throw new IndexOutOfBoundsException(" Column's length must not be above 1. [" + columnName + "]");
	    }
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet, java.lang.String)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, String columnName)
			throws SQLException {
		return rs.getString(columnName);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetData(java.sql.ResultSet, int)
	 */
	@Override
	public Object getResultsetData(ResultSet rs, int columnIndex)
			throws SQLException {
		String value = rs.getString(columnIndex);;
	    if(value == null) return null;
	        
	    char chars[] = value.toCharArray();
	        
	    if(chars.length == 1){
	    	 return new Character(chars[0]);
	    } else if(chars.length == 0) {
	        return null;
	    } else {
	    	//TODO message move to property file.
	    	throw new IndexOutOfBoundsException(" Column's length must not be above 1 . [column index = " + columnIndex + "]");
	    }
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.type.Type#getResultsetDataToString(java.sql.ResultSet, int)
	 */
	@Override
	public String getResultsetDataToString(ResultSet rs, int columnIndex)
			throws SQLException {
		return rs.getString(columnIndex);
	}
}