/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/17
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FInfo.java
 */
package net.sf.thirdi.jdbc;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/**
 * <i>Tv(abstract)</i>F 񋟃NX
 *@.<p>
 * 񋟃NX
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class Info {
	
	//private static final Logger log = java.util.logging.Logger.getLogger(Info.class.getName());

	public static void main(String[] args) {
		
		Class<?> clazz = Info.class;
		String classFileName = clazz.getSimpleName() + ".class";
		String classFilePath = clazz.getCanonicalName().replace( '.', '/' )+ ".class";
		String pathToThisClass =
				clazz.getResource( classFileName ).toString();
		String pathToManifest = pathToThisClass.substring( 0, pathToThisClass.indexOf( classFilePath ) - 1 )
				+ "/META-INF/MANIFEST.MF";
		Manifest manifest = null;
		String version = null;
		String url = null;
		String title = null;
		try {
			manifest = new Manifest( new URL( pathToManifest ).openStream() );
		} catch ( Exception e ) {
			System.out.println( "Unable to determine manifest of thirdi-orm" );
		}
		if ( manifest != null ) {
			version = manifest.getMainAttributes().getValue( Attributes.Name.IMPLEMENTATION_VERSION );
			url = manifest.getMainAttributes().getValue( Attributes.Name.IMPLEMENTATION_URL );
			title = manifest.getMainAttributes().getValue( Attributes.Name.IMPLEMENTATION_TITLE );
		}
		
		if (version==null) version = "?";
		if (url==null) url = "http://sourceforge.jp/projects/thirdi/";
		if (title==null) title = "thirdi-orm";
		System.out.println( "------------------------------------" );
		System.out.println( "         THIRD-i@Project          " );
		System.out.println( "------------------------------------" );
		System.out.println( "@titleEEEEEEEEEE : " + title );
		System.out.println( "@versionEEEEEEEE : " + version );
		System.out.println( "@urlEEEEEEEEEEEE : " + url );

		
	}
}
