/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/16
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FCSVHeaderInfoImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.thirdi.jdbc.CSVColumn;
import net.sf.thirdi.jdbc.CSVHeaderInfo;
import net.sf.thirdi.jdbc.MappingLetterType;

/**
 * <i>Tv(abstract)</i>F CSVHeaderInfo
 *@.<p>
 * CSVHeaderInfo<BR>
 * {@link net.sf.thirdi.jdbc.CSVHeaderInfo}
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
class CSVHeaderInfoImpl implements CSVHeaderInfo{
	
	private Map<String,CSVColumn> m = new ConcurrentHashMap<String,CSVColumn>();
	
	private List <String> nameList = new ArrayList<String>();
	
	private MappingLetterType mappinglettertype = MappingLetterType.ORIGINAL_LETTER;
	
	
	void setColumn(String columnName,CSVColumn column){
		
		if (column == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("column must not be null.");
		
		if (columnName == null || "".equals(columnName))
			// TODO message move to property file.
			throw new IllegalArgumentException("columnName must not be null or blank.");
		
		if (nameList== null ) nameList = new ArrayList<String>();
		if (m ==  null) m = new ConcurrentHashMap<String,CSVColumn>();
		this.nameList.add(columnName.toUpperCase());
		this.m.put(columnName.toUpperCase(), column);
	}
	
	
	private String getColumnName(int index) {
		return nameList.get(index - 1);
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#getCSVColumn(int)
	 */
	@Override
	public CSVColumn getCSVColumn(int index) throws IndexOutOfBoundsException {
		if (index <= 0)
			// TODO message move to property file.
			throw new NegativeArraySizeException("index size must not be negative.");
		
		if (nameList.size() < index)
			// TODO message move to property file.
			throw new IndexOutOfBoundsException("index size must not be above column's size.");
			
		return m.get(getColumnName(index));
		 
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#getCSVColumn(java.lang.String)
	 */
	@Override
	public CSVColumn getCSVColumn(String columnName)
			throws NoSuchElementException {
		if (columnName == null || "".equals(columnName))
			// TODO message move to property file.
			throw new IllegalArgumentException("columnName must not be null or blank.");
	
		return m.get(columnName.toUpperCase());
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#getMappingLetterType()
	 */
	@Override
	public MappingLetterType getMappingLetterType() {
		return mappinglettertype;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#setCSVColumn(int, net.sf.thirdi.jdbc.CSVColumn)
	 */
	@Override
	public void setCSVColumn(int index, CSVColumn column)
			throws IllegalArgumentException, NegativeArraySizeException,
			IndexOutOfBoundsException {
		
		if (index <= 0)
			// TODO message move to property file.
			throw new NegativeArraySizeException("index size must not be negative.");
		
		if (nameList.size() < index)
			// TODO message move to property file.
			throw new IndexOutOfBoundsException("index size must not be above column's size.");
		
		
		if (column == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("column must not be null.");
		
		String columnNameKey = getColumnName(index);
		
		if (m.containsKey(columnNameKey)) {
			CSVColumn c = m.get(columnNameKey);
			c.setColumnAliasName(column.getColumnAliasName());
			c.setCSVColumnDecorator(column.getCSVColumnDecorator());
			m.put(columnNameKey, c);
		} 
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#setCSVColumn(java.lang.String, net.sf.thirdi.jdbc.CSVColumn)
	 */
	@Override
	public void setCSVColumn(String columnName, CSVColumn column)
			throws IllegalArgumentException, NoSuchElementException {
		if (column == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("column must not be null.");
		
		if (columnName == null || "".equals(columnName))
			// TODO message move to property file.
			throw new IllegalArgumentException("columnName must not be null or blank.");
		
		if (m.containsKey(columnName.toUpperCase())) {
			CSVColumn c = m.get(columnName.toUpperCase());
			c.setColumnAliasName(column.getColumnAliasName());
			c.setCSVColumnDecorator(column.getCSVColumnDecorator());
			m.put(columnName.toUpperCase(), c);
		} else {
			// TODO message move to property file.
			throw new NoSuchElementException("not found column name. [" + columnName + "]");
		}
		
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#setMappingLetterType(net.sf.thirdi.jdbc.MappingLetterType)
	 */
	@Override
	public void setMappingLetterType(MappingLetterType type) {
		this.mappinglettertype = type;
	}


	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVHeaderInfo#getColumnCount()
	 */
	@Override
	public int getColumnCount() {
		return nameList.size();
	}
}
