/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.type
 * t@C  (file name)    FType.java
 */
package net.sf.thirdi.jdbc.type;

import java.sql.ResultSet;
import java.sql.SQLException;

import net.sf.thirdi.jdbc.meta.ElementDesc;

/**
 * <i>Tv(abstract)</i>F SQLTYPE݊JAVATYPE̊֘A\B
 *@.<p>
 *@SQLTYPE݊JAVATYPE̊֘A\B<BR>
 *@Ǝ̌^}bsO邽߂ɂ͂̃C^[tF[XNX<BR>
 *@{@link net.sf.thirdi.jdbc.typeresolver}Ɋ֘AÂ܂B<BR>
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public interface Type {

	/**
	 * <i>Tv(abstract)</i>F ΏۃJɑ΂ΏTYPEf[^ZbgB
	 * .<p>
	 * ΏۃJɑ΂ΏTYPEf[^ZbgB
	 *@
	 * @param rs
	 * @param bean
	 * @param elementdesc
	 * @param columnName
	 */
	public void set(ResultSet rs,Object bean ,ElementDesc elementdesc, String columnName);

	
	/**
	 * <i>Tv(abstract)</i>F {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * .<p>
	 * {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 *@
	 * @param rs@{java.sql.ResultSet}IuWFNg
	 * @param columnName@J
	 * @return@擾l
	 * @throws SQLException
	 */
	public Object getResultsetData(ResultSet rs,String columnName) throws SQLException;
	
	
	/**
	 * <i>Tv(abstract)</i>F {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * .<p>
	 * {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 *@
	 * @param rs {java.sql.ResultSet}IuWFNg
	 * @param columnIndex JCfbNX
	 * @return@擾l
	 * @throws SQLException
	 */
	public Object getResultsetData(ResultSet rs,int columnIndex) throws SQLException;
	
	
	/**
	 * <i>Tv(abstract)</i>F {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * .<p>
	 * {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * 擾lStrinǧ^ɕϊĕԂ܂B
	 *@
	 * @param rs@{java.sql.ResultSet}IuWFNg
	 * @param columnName@J
	 * @return@擾f[^Stringɕϊl
	 * @throws SQLException
	 */
	public String getResultsetDataToString(ResultSet rs,String columnName) throws SQLException;
	
	
	
	/**
	 * <i>Tv(abstract)</i>F {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * .<p>
	 * {java.sql.ResultSet}̃\bh𗘗pf[^擾܂B
	 * 擾lStrinǧ^ɕϊĕԂ܂B
	 *@
	 * @param rs@{java.sql.ResultSet}IuWFNg
	 * @param columnIndex@JCfbNX
	 * @return@擾f[^Stringɕϊl
	 * @throws SQLException
	 */
	public String getResultsetDataToString(ResultSet rs,int columnIndex) throws SQLException;
	/*
	Java ̌^Ƀ}bsO JDBC ̌^
	JDBC ̌^ Java ̌^
	
	CHAR String
	VARCHAR String
	LONGVARCHAR String
	NUMERIC java.math.BigDecimal
	DECIMAL java.math.BigDecimal
	BIT boolean
	TINYINT byte
	SMALLINT short
    INTEGER int
	BIGINT long
	REAL float
	FLOAT double
	DOUBLE double
	BINARY byte[]
	VARBINARY byte[]
	LONGVARBINARY byte[]
	DATE java.sql.Date
	TIME java.sql.Time
	TIMESTAMP java.sql.Timestamp
	CLOB Clob
	BLOB Blob
	ARRAY Array
	DISTINCT ̌^̃}bsO
	STRUCT Struct
	REF Ref
	JAVA_OBJECT  Java NX
	
	̕\ɂ́A2 ̖ړI܂B܂A̕\́AJava vO~Ǒ^ SQL ̌^Ƃ̊Ԃ̈ʓIȑΉĂ܂B܂ACallableStatement.getXXX \bh SQLInput.readXXX \bhɂĎg}bsO\Ă܂BCallableStatement.getObject \bhŎg}bsOɂẮA\ 8.3 QƂĂB
	
	
	8.9.2 JDBC ̌^Ƀ}bsO Java ̌^
	
	Java ̌^  JDBC ̌^
	
	String CHARAVARCHARA܂ LONGVARCHAR
	java.math.BigDecimal NUMERIC
	boolean BIT
	byte TINYINT
	short SMALLINT
	int INTEGER
	long BIGINT
	float REAL
	double DOUBLE
	byte[] BINARYAVARBINARYA܂ LONGVARBINARY
	java.sql.Date DATE
	java.sql.Time TIME
	java.sql.Timestamp TIMESTAMP 
	Clob CLOB
	Blob BLOB
	Array ARRAY
	Struct STRUCT
	Ref REF
	Java NX JAVA_OBJECT
	
	̕\́AIN p[^ DBMS ɑMOɎgϊĂ܂B PreparedStatement.setXXX  RowSet.setXXX \bhɂĎg܂B̕ΐAResultSet.updateXXX \bh SQLOutput.writeXXX \bhłg܂BPreparedStatement.setObject  RowSet.setObject \bh́A\ 8.4 ̃}bsOg܂B
	String ɑ΂}bsO͒ʏ VARCHAR łAl VARCHAR lɑ΂hCǒE𒴂Ăꍇ́ALONGVARCHAR ɂȂ܂Bbyte[] ̏ꍇlŁAVARCHAR lɑ΂hCǒEɉāAVARBINARY ܂ LONGVARBINARY lɃ}bsO܂BقƂǂ̏ꍇACHAR  VARCHAR ̑I͏dvł͂܂BhCoɂēK؂ɑI܂BBINARY  VARBINARY ̑IlłB
	
	
	8.9.3 Java ̃IuWFNg^Ƀ}bsO JDBC ̌^
	
	JDBC ̌^

	Java ̃IuWFNg^
	
	CHAR String
	VARCHAR String
	LONGVARCHAR String
	NUMERIC java.math.BigDecimal
	DECIMAL java.math.BigDecimal
	BIT Boolean
	TINYINT Integer
    SMALLINT Integer
    INTEGER Integer 
    BIGINT Long 
    REAL Float 
    FLOAT Double 
    DOUBLE Double 
    BINARY byte[] 
    VARBINARY byte[] 
    LONGVARBINARY byte[] 
    DATE java.sql.Date 
    TIME java.sql.Time 
    TIMESTAMP java.sql.Timestamp 
    DISTINCT ̌^̃IuWFNg^
	CLOB Clob
	BLOB Blob
	ARRAY Array
	STRUCT Struct ܂ SQLData
	REF Ref
	JAVA_OBJECT  Java NX
	
	̕\́AResultSet.getObject  CallableStatement.getObject \bhŎgAJDBC ̌^ Java ̃IuWFNg^ւ̃}bsOĂ܂B
	8.9.4 JDBC ̌^Ƀ}bsO Java ̃IuWFNg^
	
	Java ̃IuWFNg^ JDBC ̌^
	
	String CHARAVARCHARA܂ LONGVARCHAR
	java.math.BigDecimal NUMERIC
	Boolean BIT
	Integer INTEGER
	Long BIGINT
	Float REAL
	Double DOUBLE
	byte[] BINARYAVARBINARYA܂ LONGVARBINARY
	java.sql.Date DATE
	java.sql.Time TIME
	java.sql.Timestamp TIMESTAMP
	Clob CLOB
	Blob BLOB
	Array ARRAY
	Struct STRUCT
	Ref REF
	Java NX JAVA_OBJECT 
    */
	
	
}
