package net.sf.thirdi.validation;
/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import net.sf.thirdi.validation.config.BeanValueParameter;
import net.sf.thirdi.validation.constraint.ValidateWithJavaScriptConstraint;
import net.sf.thirdi.validation.spec.ConstraintValidator;

@Documented
@ConstraintValidator(ValidateWithJavaScriptConstraint.class)
@BeanValueParameter
@Target( { METHOD, FIELD, ANNOTATION_TYPE })
@Retention(RUNTIME)
public @interface ValidateWithJavaScript {

	String expression();

	int index() default -1;

	String name() default "";

	boolean nullability() default true;

	String[] groups() default {};

	String message() default "{"
			+ "net.sf.thirdi.validation.ValidateWithMethod" + "}";
}
