/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.constraint;

import net.sf.thirdi.validation.RequireHankakuKana;
import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintContext;
import net.sf.thirdi.validation.util.Assertion;

public final class RequireHankakuKanaConstraint implements
		Constraint<RequireHankakuKana> {

	private boolean nullability;

	private static final String HANKAKU_KANA = " "
			+ "ܦݧ߰";

	public void initialize(RequireHankakuKana constraintAnnotation) {
		this.nullability = constraintAnnotation.nullability();
	}

	public boolean isValid(Object value, ConstraintContext constraintcontext) {
		if (this.nullability) {
			if (value == null)
				return true;
		}
		Assertion.isStringType(value);
		String buf = (String) value;

		for (int i = 0; i < buf.length(); i++) {
			char c = buf.charAt(i);

			if (-1 == HANKAKU_KANA.indexOf((int) c)) {
				return false;
			}
		}

		return true;
	}

}
