/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.constraint;

import java.lang.reflect.Method;

import net.sf.thirdi.validation.ValidateWithMethod;
import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintContext;
import net.sf.thirdi.validation.util.ReflectionUtils;

public final class ValidateWithMethodConstraint implements
		Constraint<ValidateWithMethod> {

	private String methodName;

	private boolean nullability;

	public void initialize(ValidateWithMethod constraintAnnotation) {
		this.methodName = constraintAnnotation.methodName();
		this.nullability = constraintAnnotation.nullability();

	}

	public boolean isValid(Object bean, ConstraintContext constraintcontext) {
		if (nullability) {
			if (bean == null)
				return true;
		} else {
			if (bean == null)
				throw new NullPointerException("parameter value is null.");
		}

		if (this.methodName == null || "".equals(this.methodName))
			throw new RuntimeException(new NoSuchMethodException(
					"method name is null or empty."));

		Method m = ReflectionUtils.getMethodRecursive(bean.getClass(),
				this.methodName, (Class[]) null);

		if (m == null)
			throw new RuntimeException(new NoSuchMethodException(
					this.methodName + " is missing."));

		if (m.getReturnType() != boolean.class) {
			throw new RuntimeException(new NoSuchMethodException(
					this.methodName + " returnType must be boolean value."));
		}

		Object result = ReflectionUtils.invokeMethod(m, bean, (Object[]) null);
		if (!(result instanceof Boolean))
			throw new RuntimeException(this.methodName
					+ "returnType must be boolean value.");
		return (Boolean) result;

	}

}
