/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintDescriptor;

public class TIConstraintDescriptor implements ConstraintDescriptor {

	private final Constraint<?> constraint;

	private final Set<String> groups;

	private final Annotation annotation;

	private Set<ConstraintDescriptor> composedConstraints;

	private final boolean reportFromComposite;

	private Map<String, Object> parameters;

	@SuppressWarnings("all")
	private TIConstraintDescriptor() {
		this.constraint = null;
		this.groups = null;
		this.annotation = null;
		this.reportFromComposite = false;
		this.parameters = null;
	}

	TIConstraintDescriptor(Constraint<?> constraint, Set<String> groups,
			Annotation annotation,
			Set<ConstraintDescriptor> composedConstraints,
			boolean reportFromComposite, Map<String, Object> parameters) {

		this.constraint = constraint;
		this.groups = groups;
		this.annotation = annotation;
		this.composedConstraints = composedConstraints;
		this.reportFromComposite = reportFromComposite;
		this.parameters = parameters;
	}

	public Annotation getAnnotation() {
		return this.annotation;
	}

	public Set<ConstraintDescriptor> getComposingConstraints() {
		return composedConstraints;
	}

	@SuppressWarnings("unchecked")
	public Class<? extends Constraint<?>> getConstraintClass() {
		return (Class<? extends Constraint<?>>) constraint.getClass();
	}

	public Set<String> getGroups() {
		return groups;
	}

	public Map<String, Object> getParameters() {
		return parameters;
	}

	public boolean isReportAsViolationFromCompositeConstraint() {
		return reportFromComposite;
	}

	public Set<ConstraintDescriptor> getComposedConstraints() {
		return composedConstraints;
	}

	public void setComposedConstraints(
			Set<ConstraintDescriptor> composedConstraints) {
		this.composedConstraints = composedConstraints;
	}

}
