/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core.meta;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

import net.sf.thirdi.validation.spec.Constraint;
import net.sf.thirdi.validation.spec.ConstraintDescriptor;

public class ConstraintAttributeDesc implements ConstraintDescriptor,
		ConstraintIndexable {

	private ConstraintDescriptor constraintdescriptor;

	private Annotation annotation;

	private Set<ConstraintDescriptor> composingConstraints;

	private Class<? extends Constraint<?>> constraintClass;

	private Set<String> groups;

	private boolean isGroups;

	private Map<String, Object> parameters;

	private boolean isReportAsViolationFromCompositeConstraint;

	private String name;

	private String id;

	private int index;

	private boolean isBeanValueParameter;

	private boolean isUsingJPAColumn;

	public boolean isBeanValueParameter() {
		return isBeanValueParameter;
	}

	public void setBeanValueParameter(boolean isBeanValueParameter) {
		this.isBeanValueParameter = isBeanValueParameter;
	}

	ConstraintAttributeDesc() {

	}

	ConstraintAttributeDesc(ConstraintDescriptor constraintdescriptor,
			boolean isconstraint, Annotation annotation,
			Set<ConstraintDescriptor> composingConstraints,
			Class<? extends Constraint<?>> constraintClass, Set<String> groups,
			Map<String, Object> parameters,
			boolean isReportAsViolationFromCompositeConstraint) {

		this.constraintdescriptor = constraintdescriptor;
		// this.isconstraint = isconstraint;
		this.annotation = annotation;
		this.composingConstraints = composingConstraints;
		this.constraintClass = constraintClass;
		this.groups = groups;
		this.parameters = parameters;
		this.isReportAsViolationFromCompositeConstraint = isReportAsViolationFromCompositeConstraint;

	}

	public Annotation getAnnotation() {
		return annotation;
	}

	public Set<ConstraintDescriptor> getComposingConstraints() {
		return composingConstraints;
	}

	public Class<? extends Constraint<?>> getConstraintClass() {
		return constraintClass;
	}

	public Set<String> getGroups() {
		return groups;
	}

	public Map<String, Object> getParameters() {
		return parameters;
	}

	public boolean isReportAsViolationFromCompositeConstraint() {
		return isReportAsViolationFromCompositeConstraint;
	}

	public ConstraintDescriptor getConstraintdescriptor() {
		return constraintdescriptor;
	}

	public void setConstraintdescriptor(
			ConstraintDescriptor constraintdescriptor) {
		this.constraintdescriptor = constraintdescriptor;
	}

	public void setAnnotation(Annotation annotation) {
		this.annotation = annotation;
	}

	public void setComposingConstraints(
			Set<ConstraintDescriptor> composingConstraints) {
		this.composingConstraints = composingConstraints;
	}

	public void setConstraintClass(
			Class<? extends Constraint<?>> constraintClass) {
		this.constraintClass = constraintClass;
	}

	public void setGroups(Set<String> groups) {
		this.groups = groups;
	}

	public void setReportAsViolationFromCompositeConstraint(
			boolean isReportAsViolationFromCompositeConstraint) {
		this.isReportAsViolationFromCompositeConstraint = isReportAsViolationFromCompositeConstraint;
	}

	public void setParameters(Map<String, Object> parameters) {
		this.parameters = parameters;
	}

	public int getIndex() {
		return index;
	}

	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void setName(String name) {
		this.name = name;
	}

	public boolean isGroups() {
		return isGroups;
	}

	public void setGroups(boolean isGroups) {
		this.isGroups = isGroups;
	}

	/**
	 * <i>Tv(abstract)</i>F Return the
	 * {@link net.sf.thirdi.validation.core.meta.ConstraintAttributeDesc#isUsingJPAColumn}
	 * .
	 * <p>
	 * Return the
	 * {@link net.sf.thirdi.validation.core.meta.ConstraintAttributeDesc#isUsingJPAColumn}
	 * . @
	 * 
	 * @return the isUsingJPAColumn
	 */
	public boolean isUsingJPAColumn() {
		return isUsingJPAColumn;
	}

	/**
	 * <i>Tv(abstract)</i>FSet the
	 * {@link net.sf.thirdi.validation.core.meta.ConstraintAttributeDesc#isUsingJPAColumn}
	 * .
	 * <p>
	 * Set the
	 * {@link net.sf.thirdi.validation.core.meta.ConstraintAttributeDesc#isUsingJPAColumn}.
	 * 
	 * @param isUsingJPAColumn
	 *            the isUsingJPAColumn to set
	 */
	public void setUsingJPAColumn(boolean isUsingJPAColumn) {
		this.isUsingJPAColumn = isUsingJPAColumn;
	}
}
