/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.core.meta;

import java.util.List;
import java.util.Map;
import java.util.Set;


public class ConstraintClassDesc implements ObjectId{
	
	
	private List<ConstraintClassDesc> interfaces;
	
	private ConstraintClassDesc superclass;
	
	private List<ConstraintAttributeDesc> attribute;
	
	private List<ConstraintFieldDesc> field;
	
	private List<ConstraintPropertyDesc> property;
	
	private Map<String,Set<String>> groupseaquence;
	
	private Class<?> constraintClass;
	
	private String id;
	
	private String name;


	public List<ConstraintAttributeDesc> getAttribute() {
		return attribute;
	}


	public void setAttribute(List<ConstraintAttributeDesc> attribute) {
		this.attribute = attribute;
	}


	public Class<?> getConstraintClass() {
		return constraintClass;
	}

	public void setConstraintClass(Class<?> constraintClass) {
		this.constraintClass = constraintClass;
	}


	public List<ConstraintFieldDesc> getField() {
		return field;
	}


	public void setField(List<ConstraintFieldDesc> field) {
		this.field = field;
	}


	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public List<ConstraintPropertyDesc> getProperty() {
		return property;
	}


	public void setProperty(List<ConstraintPropertyDesc> property) {
		this.property = property;
	}

	/* (non-Javadoc)
	 * @see jp.co.qon.qlick.validation.core.meta.ObjectId#getName()
	 */
	public String getName() {
		return name;
	}


	public List<ConstraintClassDesc> getInterfaces() {
		return interfaces;
	}


	public void setInterfaces(List<ConstraintClassDesc> interfaces) {
		this.interfaces = interfaces;
	}


	public ConstraintClassDesc getSuperclass() {
		return superclass;
	}


	public void setSuperclass(ConstraintClassDesc superclass) {
		this.superclass = superclass;
	}


	public void setName(String name) {
		this.name = name;
	}


	public Map<String, Set<String>> getGroupseaquence() {
		return groupseaquence;
	}


	public void setGroupseaquence(Map<String, Set<String>> groupseaquence) {
		this.groupseaquence = groupseaquence;
	}
	

	public ConstraintFieldDesc getFieldDesc(String fieldName) {
		
		if (fieldName == null || "".equals(fieldName)) return null;
		if (this.field == null) return null;
		
		for (int i = 0; i < this.field.size(); i++) {
			ConstraintFieldDesc cfd = field.get(i);
			if (fieldName.equals(cfd.getFieldName())) {
				return cfd;
			}
			
		}
		
		return null;
	}
	

	public List<ConstraintAttributeDesc>  getFieldAttributeDesc(String fieldName) {
		
		ConstraintFieldDesc cfd = getFieldDesc(fieldName);
		if (cfd ==null ){
			return null;
		} else {
			return cfd.getAttribute();
		}
		
		
	}

}
