/*
 * Copyright 2009- kensir0u.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package net.sf.thirdi.validation.util;

import java.io.StringReader;
import java.util.Map;
import java.util.Map.Entry;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

abstract class AbstractScriptUtil {

	private static ScriptEngine engine;

	protected static ScriptDescriptor sd;

	interface ScriptDescriptor {

		String getName();

		String getKey();

	}

	private static ScriptEngine getEngine() {
		if (sd == null)
			return null;
		return new ScriptEngineManager().getEngineByName(sd.getKey());
	}

	protected static void initialize() {
		if (engine == null)
			engine = getEngine();

	}

	protected Object eval(final String expression, final Map<String, ?> values) {

		if (expression == null)
			throw new NullPointerException("expression is null.");

		if (engine == null) {
			if (sd == null) {
				throw new UnsupportedClassVersionError(sd.getName()
						+ " engine unsupported.");
			} else {
				throw new UnsupportedClassVersionError(
						"should be extends this class.");
			}
		}

		StringReader reader = new StringReader(expression);

		Bindings bindings = engine.getBindings(ScriptContext.ENGINE_SCOPE);

		for (final Entry<String, ?> entry : values.entrySet()) {
			bindings.put(entry.getKey(), entry.getValue());
		}

		try {

			return engine.eval(reader);

		} catch (ScriptException ex) {
			throw new RuntimeException(ex);
		} finally {
			reader.close();
		}
	}

	protected Object eval(final String expression, String key, Object bean) {

		if (expression == null)
			throw new NullPointerException("expression is null.");

		if (engine == null) {
			if (sd == null) {
				throw new UnsupportedClassVersionError(sd.getName()
						+ " engine unsupported.");
			} else {
				throw new UnsupportedClassVersionError(
						"should be extends this class.");
			}
		}

		StringReader reader = new StringReader(expression);

		Bindings bindings = engine.getBindings(ScriptContext.ENGINE_SCOPE);

		if (key != null) {
			bindings.put(key, bean);
		}
		try {

			return engine.eval(reader);

		} catch (ScriptException ex) {
			throw new RuntimeException(ex);
		} finally {
			reader.close();
		}
	}

}
