<?php
/*----------------------------------------------------

  Ls.plugin.phpThreadWiki֥ꥹȡPlugin
   Copyright(C) 2003 by FLATz Co , LTd.
  
  Release note
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
         Ρޥ
  ǽ       ɽ˥ڡ̾ΰִ
  ƤӽФ #Ls(NAMESPACE);
               NAMESPACE : ꤷ̾ΰɽ
			   PARAMETER(ʣ) : ѥ᡼
			     title   : ڡ˴ޤޤ(*,**,***)ΰʻ
				 headline  : titleΥꥢ
               
------------------------------------------------------*/

require_once("Wiki/PluginBase.php");

define("MAX_LIST_STEP", 5);
define("MAX_HEADLINE_STEP", 3);

class Ls extends PluginBase
{

/*----------------------------------------------------

  Ls(&$core,&$config,&$wiki_db)󥹥ȥ饯

------------------------------------------------------*/
function Ls(&$core,&$config,&$wiki_db)
{
	parent::PluginBase($core,$config,$wiki_db);
}
//-----------------------------------------------------

/*----------------------------------------------------

------------------------------------------------------*/
function preprocess_function(
  &$wiki_renderer, $line_number, &$row_line_array, $argument_array
){
	//
	// 
	//
	$wikiname = $argument_array[0];
	if($wikiname == ""){
		$wikiname = "/";
		if($this->process_status['namespace'] != ""){
			$wikiname .= $this->process_status['namespace'] . "/";
		}
		$wikiname .= $this->process_status['pagename'];
	}

	// Хѥ
	$wikiname = $this->replace_relative_path($wikiname, $this->process_status['namespace']);

	// ꥹȤΥ롼Ƚ
	$root_state = "page";
	$wikiname_info = $this->pathinfo($wikiname);
	if($wikiname_info['basename'] == ""){
		$root_state = "namespace";
	}

	$ls_list = array(
	  "state" => "namespace",
	  "children" => array(
	    $wikiname => array(
		  "state" => $root_state,
	      "children" => array()
        )
	  )
	);

	// 롼ȤλҶ鸡
	$result = $this->get_list(
	  $wikiname, $ls_list['children'][$wikiname]['children']);
	if(!$result)
		return "Plugin error <br>";

	// (ѥ᡼)
	for($i=1;$i<count($argument_array);$i++){
		$argument = $argument_array[$i];
		switch( strtolower($argument) ){
		case "headline":
		case "title":
			// ФڡꥹȤ˥ޡ
			$result = $this->get_headline($ls_list['children']);
			break;
		default:
			$result = true;
			break;
		}
		if(!$result)
			return "Plugin error <br>";
	}

	//
	// ڡꥹȤWikiɽ
	//
	$wiki_notation_array = $this->get_display_list($ls_list['children']);

	//
	// ֤
	//
	array_splice($row_line_array, $line_number, 1);
	array_splice($row_line_array, $line_number, 0, $wiki_notation_array);
}
//-----------------------------------------------------

/*----------------------------------------------------

  ְ̾ʲΥڡꥹȤ
  private get_list(
    in  $namespace : String
    out $list : Array
  ) : Bool

------------------------------------------------------*/
function get_list( $namespace, &$list ){
	// ڡ
	$page_data_list =
	  $this->wiki_db->get_page_list($namespace,'target_level_only');
	foreach( $page_data_list as $page_data ){
		// ڡꥹȤϿ
		/*
		  TwDatabase::get_page_list ֤ PageData::data['name_space']
		  Ū / ƬˤĤ֤Ƥ
		  
		*/
		$wikiname = "";
		if($page_data->data['name_space'] != ""){
			if(!preg_match("/^\//", $page_data->data['name_space']))
				$wikiname .= "/";
				
			$wikiname .= $page_data->data['name_space'];
		}
		$wikiname .= "/" . $page_data->data['name'];

		$list[$wikiname]['state']    = "page";
		$list[$wikiname]['children'] = array();
	}

	// ̾
	$namespace_list =
	  $this->wiki_db->get_namespace_list($namespace,'target_level_only');
	foreach( $namespace_list as $namespace ){
		// ֤̾ꥹȤϿ
		$namespace = preg_replace("/\/+/", "/", $namespace);
		$list[$namespace]['state']    = "namespace";
		$list[$namespace]['children'] = array();
		$this->get_list($namespace, $list[$namespace]['children']);
	}

	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  ФڡꥹȤ˥ޡ
  private get_headline(
    in/out $list : Array
  ) : Bool

------------------------------------------------------*/
function get_headline( &$list ){
	foreach( $list as $wikiname => $low_list ){
		// ʸ
		$target_page = new PageData();
		$wikiname_info = $this->pathinfo($wikiname);
		if($this->wiki_db->load(
		  $target_page,
		  $wikiname_info['basename'], $wikiname_info['dirname'],
		  'target_level_only')
  		){
			// Фθ
			$this->get_headline_from_body(
			  $list[$wikiname]['children'], $target_page->data);
		}

		// ҶθФ⸡
		$this->get_headline($list[$wikiname]['children']);
	}
	return true;
}
//-----------------------------------------------------

function get_headline_from_body( &$list, $search_data, $search_level=1, $current_pos=0 ){
	
	if($search_level <= 0 || $current_pos < 0)
		return count($search_data['body'])+1;

	if($search_level > MAX_HEADLINE_STEP)
		return $current_pos-1;

	for($pos=$current_pos; $pos<count($search_data['body']); $pos++){
		$result = preg_match("/^(\*+)(.*)$/", $search_data['body'][$pos], $matches); 
		if(!$result)
			continue;

		if($search_level > strlen($matches[1])){
			// ̤θФĤä
			// ̤θФǤҤäƤ餦
			return $pos-1;
		}
		else if( $search_level == strlen($matches[1]) ){
			// Υ٥θФĤä
			// ꥹȤ˥ޡ
			$wikiname = "";
			if($search_data['name_space'] != ""){
				if(!preg_match("/^\//", $search_data['name_space']))
					$wikiname .= "/";
					
				$wikiname .= $search_data['name_space'];
			}
			$wikiname .= "/" . $search_data['name'];

			$anchor_wikiname = $wikiname . "#" . $matches[2];
			$list[$anchor_wikiname]['state']    = "headline";
			$list[$anchor_wikiname]['children'] = array();

			// ̤θФ򸡺
			$pos = $this->get_headline_from_body($list[$anchor_wikiname]['children'], $search_data, $search_level+1, $pos+1);
			
		}
		else{
			// ̤θФĤä
			// ߡ֥٥θФ
			$anchor_wikiname = "none";
			$list[$anchor_wikiname]['state']    = "none";
			$list[$anchor_wikiname]['children'] = array();

			// ̤θФˤҤäƤ餦
			$pos = $this->get_headline_from_body($list[$anchor_wikiname]['children'], $search_data, $search_level+1, $pos);
		}
	}
	return $pos;
}

/*----------------------------------------------------

  ڡꥹȤWikiɽ
  private get_display_list(
    in $list : Array
  ) : Bool

------------------------------------------------------*/
function get_display_list( $list, $level=0 ){
	$wiki_notation_array = array();

	if(!is_array($list))
		$list = array();
	foreach( $list as $name => $low_list ){
		// ̥ꥹȤĤ
		if(count($low_list['children'])){
			/*
			  ꥹȤʳϥڡ/Ѥ˰ʳפƤɬ
			  뤿ᣱʳ餹
			*/
			if($level >= MAX_LIST_STEP)
				$level = MAX_LIST_STEP - 1;
		}
		else{
			if($level > MAX_LIST_STEP)
				$level = MAX_LIST_STEP;
		}

		if($level==0){
			$wiki_notation_array[] = "***[[{$name}]]";
		}
		else{
			if($low_list['state'] == "namespace"){
				// ֤̾ξ硢Ǹ/Ĥ
				$wiki_notation_array[] =
				  str_repeat("-", $level) . "[[{$name}/]]";
			}
			else if($low_list['state'] == "page"){
				$wiki_notation_array[] =
				  str_repeat("-", $level) . "[[{$name}]]";
			}
			else if($low_list['state'] != "none"){
				$wiki_notation_array[] =
				  str_repeat("-", $level) . "<[[{$name}]]>";
			}
		}

		// ̥ꥹȤ˽ܤ
		if(count($low_list['children'])){
			$merge_array = $this->get_display_list($low_list['children'], $level+1);
			$wiki_notation_array = array_merge($wiki_notation_array, $merge_array);
		}
		
	}
	return $wiki_notation_array;
}
//-----------------------------------------------------

/*----------------------------------------------------

  pathinfo() γĥ
  åǽ path ξ basename ˤϲ֤ʤ
  private pathinfo(
    in $wikiname : String
  ) : Hash

------------------------------------------------------*/
function pathinfo( $wikiname ){
	$wikiname_info = array();
	if(preg_match("/\/$/", $wikiname)){
		$wikiname_info['dirname']  = $wikiname;
		$wikiname_info['basename'] = "";
	}
	else{
		$wikiname_info = pathinfo($wikiname);
	}
	return $wikiname_info;
}
//-----------------------------------------------------

function replace_relative_path( $wikiname, $current_path ){
	// WikiName åǻϤޤϥ롼
	if(preg_match("/^\//", $wikiname))
		return $wikiname;

	$remains = $wikiname;
	do{
		list($target, $remains) = explode("/", $remains, 2);
		if($target == "."){
			// ⤷ʤ
			//$current_path = $current_path;
		}
		else if($target == ".."){
			// ȥѥ򣱤ľγؤ˰ư
			$current_path_info = pathinfo($current_path);
			$current_path = $current_path_info['dirname'];
		}
		else{
			// ȥѥ򣱤Ĳγؤ˰ư
			$current_path .= "/" . $target;
		}
	}while($remains);

	if(preg_match("/\/$/", $wikiname))
		$current_path .= "/";

	if($current_path == "")
		return "/";
	else
		return "/" . $current_path;
}
//-----------------------------------------------------
}
?>
