<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines all the backup steps that will be used by {@link backup_openmeetings_activity_task}
 *
 * @package     mod_openmeetings
 * @category    backup
 * @copyright   2010 David Mudrak <david.mudrak@gmail.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Defines the complete openmeetings structure for backup, with file and id annotations
 *
 * @link http://docs.moodle.org/dev/Workshop for XML structure diagram
 */
class backup_openmeetings_activity_structure_step extends backup_activity_structure_step {

    /**
     * Defines the structure of the 'openmeetings' element inside the openmeetings.xml file
     *
     * @return backup_nested_element
     */
    protected function define_structure() {

        // root element describing openmeetings instance
        $openmeetings = new backup_nested_element('openmeetings', array('id'), array(
            //'id',
            'course',
            'teacher',
            'type',
            'is_moderated_room',
            'max_user',
            'language',
            'name',
            'intro',
            'timecreated',
            'timemodified',
            //'room_id',
            'room_recording_id',
            'allow_recording',
            ));

        $openmeetings->set_source_table('openmeetings', array('id' => backup::VAR_ACTIVITYID));

        // return the root element (openmeetings), wrapped into standard activity structure
        return $this->prepare_activity_structure($openmeetings);
    }
}
