<?php  //$Id: upgrade.php,v 1.0 2008/05/12 12:00:00 Sebastian Wagner Exp $
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

function xmldb_openmeetings_upgrade($oldversion) {
    global $CFG, $DB, $OUTPUT;
    
    $dbman = $DB->get_manager();

    $result = true;
    
    if ($oldversion < 20111001) {
    
    	// Define field allow_recording to be added to openmeetings
    	$table = new xmldb_table('openmeetings');
    	$field = new xmldb_field('allow_recording', XMLDB_TYPE_INTEGER, '10', XMLDB_UNSIGNED, XMLDB_NOTNULL, null, '1', 'room_recording_id');
    
    	// Conditionally launch add field allow_recording
    	if (!$dbman->field_exists($table, $field)) {
    		$dbman->add_field($table, $field);
    	}
    
    	// openmeetings savepoint reached
    	upgrade_mod_savepoint(true, 20111001, 'openmeetings');
    }
    
    if ($oldversion < 20111002) {
    
    	// Define field introformat to be dropped from openmeetings
    	$table = new xmldb_table('openmeetings');
    	$field = new xmldb_field('introformat');
    
    	// Conditionally launch drop field introformat
    	if ($dbman->field_exists($table, $field)) {
    		$dbman->drop_field($table, $field);
    	}
    
    	// openmeetings savepoint reached
    	upgrade_mod_savepoint(true, 20111002, 'openmeetings');
    }
    
    if ($oldversion == 20111002) {
    	//$result = false;
    	//nothing to upgrade here
    	
    }

// edit by Codia (2013/05/31)
    // モジュール管理テーブル更新
    // 管理テーブルがない場合は行わない
    if(!array_key_exists('local_ties_modules', $DB->get_tables())){
        return true;
    }

    require(dirname(__FILE__) . '/../version.php');
    if(!empty($plugin->version)){
        $version = $plugin->version;
    }else if(!empty($module->version)){
        $version = $module->version;
    }
    if(!empty($module->dispversion)){
        $dispversion = $module->dispversion;
    }else if(!empty($plugin->dispversion)){
        $dispversion = $plugin->dispversion;
    }
    $module_result = $DB->get_records_select("local_ties_modules", "name = ?", array('openmeetings'));
    if(empty($module_result)) {
        $module_info               = new stdClass();
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $module_info->name         = "openmeetings";
        $DB->insert_record('local_ties_modules', $module_info);
    }else{
        $module_info               = reset($module_result);
        $module_info->version      = $version;
        $module_info->dispversion  = $dispversion;
        $DB->update_record('local_ties_modules', $module_info);
    }
// end

    return $result;
}



?>
