<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin is used to access openmeetings videos
 *
 * @since 2.3
 * @package    repository_openmeetings
 * @copyright  2010 Dongsheng Cai {@link http://dongsheng.org}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/
require_once($CFG->dirroot . '/repository/lib.php');

class myException extends Exception {}

/**
 * repository_openmeetings class
 *
 * @since 2.3
 * @package    repository_openmeetings
 * @copyright  2009 Dongsheng Cai {@link http://dongsheng.org}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

class repository_openmeetings extends repository
{
    /**
     * openmeetings plugin constructor
     * @param int $repositoryid
     * @param object $context
     * @param array $options
     */
    public function __construct($repositoryid, $context = SYSCONTEXTID, $options = array()) {
        parent::__construct($repositoryid, $context, $options);
    }

    /**
     * Private method to get openmeetings search results
     * @return array
     */
    private function _get_collection() {
        try {
            $list = array();
            /**
             * OMプラグインファイルを利用し、OM録画データを取得
             */
            global $CFG, $DB, $OUTPUT, $COURSE;
            
            $includefile = $CFG->dirroot . '/mod/openmeetings/openmeetings_gateway.php';
            if (!file_exists($includefile)) throw new myException("Not File Exist {$includefile}");
            require_once($includefile);
            
            $omGw = new openmeetings_gateway();
            if (true!==$omGw->openmeetings_loginuser()) throw new myException("Can't Login OpenMeetings");
            $ret = $omGw->openmeetings_getFlvRecordingByExternalUserId();
            
            if (!isset($ret[0])) $omRecords[0] = $ret; else $omRecords = $ret;
            
            $sql = 'SELECT om.name, om.room_id FROM {openmeetings} om ORDER BY om.id ASC';
            $rs = $DB->get_recordset_sql($sql);
            
            $roomnames = array();
            foreach ($rs as $v) $roomnames[$v->room_id] = $v->name;
            
            foreach ( $omRecords as $v )
            {
                $fname = (isset($roomnames[$v['room_id']])) ? $roomnames[$v['room_id']]: '';
                if (!$fname) {
                    $retval = $omGw->openmeetings_getRoomById($v['room_id']);
                    if ($retval==-1) {
                        $fname = $v['fileName'];
                    }
                    else {
                        $fname = preg_replace('/MOODLE_COURSE_ID_(.*)_NAME_/', '', $retval['name']);
                    }
                }
                
                list($noneed, $ymd, $his) = explode(' ', $v['fileName']);
                list($d, $m, $y) = explode('.', $ymd);
                list($h, $i, $s) = explode(':', $his);
                $list[] = array(
                    'shorttitle'        => $fname,
                    'thumbnail_title'   => $fname,
                    'title'             => $v['fileHash'],
                    'thumbnail'         => $OUTPUT->pix_url('f/flash-80', 'core')->out(false), // OM録画データはflv固定
                    'icon'              => $OUTPUT->pix_url('f/flash-80', 'core')->out(false), // OM録画データはflv固定
                    'thumbnail_width'   => 120,
                    'thumbnail_height'  => 120,
                    'size'              => $v['fileSize'],
                    'date'              => mktime($h, $i, $s, $m, $d, $y),
                    'source'            => $CFG->mplayer_streamer_wowzadir_om.'/'.urlencode($v['fileHash']),
                    'datemodified'      => mktime($h, $i, $s, $m, $d, $y),
                    'datecreated'       => mktime($h, $i, $s, $m, $d, $y),
                );
            }
        } catch (myException $e) {
            //echo $e->getmessage();
        } catch (Exception $e) {
            throw $e;
        }
        unset($rs, $ret, $omRecords, $roomnames, $omGw);
        return $list;
    }

    /**
     * openmeetings plugin doesn't support global search
     */
    public function global_search() {
        return false;
    }

    /**
     * Get file listing
     *
     * @param string $path
     * @param string $path not used by this plugin
     * @return mixed
     */
    public function get_listing($path='', $page = '') {
        $ret = array();
        $ret['nologin'] = true;
        $ret['list'] = $this->_get_collection();
        $ret['nosearch'] = true;
        return $ret;
    }

    /**
     * Generate search form
     */
    public function print_login($ajax = true) {
        return $this->get_listing();
    }

    /**
     * file types supported by openmeetings plugin
     * @return array
     */
    public function supported_filetypes() {
        return array('video');
    }

    /**
     * openmeetings plugin only return external links
     * @return int
     */
    public function supported_returntypes() {
        return FILE_EXTERNAL;
    }
}
