<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

require_once(dirname(__FILE__) . "/lib.php");

// index.phpのみでチェックを行う。
$compare_url = trim_url($CFG->wwwroot);
$request_url = $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

$context = get_context_instance(CONTEXT_SYSTEM);
if(!has_capability('moodle/site:config', $context, null, true)){
    return;
}

// Add ties_installer administration pages to the Moodle administration menu
$ADMIN->add('root', new admin_category('local_ties', get_string('ties', 'local_ties')));

$ADMIN->add('local_ties', new admin_externalpage('ties_count', get_string('settings_count', 'local_ties'),
        $CFG->wwwroot."/local/ties/admin/count.php?id=".SITEID,
        'moodle/site:config'));

$ADMIN->add('local_ties', new admin_externalpage('ties_installcheck', get_string('settings_install', 'local_ties'),
        $CFG->wwwroot."/local/ties/admin/installcheck.php?id=".SITEID,
        'moodle/site:config'));

$ADMIN->add('local_ties', new admin_externalpage('ties_installcheck', get_string('settings_community', 'local_ties'),
        $CFG->wwwroot."/local/ties/admin/forum_ties.php",
        'moodle/site:config'));
