<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * վŪ
 * 
 * θĤġդñ
 * - 2007ǯ131׻
 * - 2007ǯ131׻
 * - 2007ǯ131⽵׻
 * - 2007ǯ131ν׻
 * - 2007ǯ1312007ǯ228
 * - 2007ǯ3312007ǯ228
 * - 2004ǯ229ǯ2005ǯ228
 * - 2007ǯ131η콵2007ǯ13
 * - 2007ǯ131η2007ǯ11
 * - 2007ǯ11ηκǽ2007ǯ131
 * 
 * 绨Ĥ˷׻ƤΤǰνΨ
 * - Ĺ֤϶Ǥ
 *  - 10ǯ塿20ǯκƸʤ
 *  - δ֤󤷤Ʒ׻ΤĹ
 * 
 * @package  tima
 * @version  SVN: $Id: DateController.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class DateController extends DateAccessor
{

    /**
     * 󥹥ȥ饯
     * 
     * @param  DateAccessor
     * @access public
     */
    function DateController(&$date_accessor)
    {
        $this->setTime($date_accessor->getTime());
    }

    /**
     * ꤵ줿ǯư
     * 
     * @param  int  $year ưǯ
     * @return void
     * @access public
     */
    function moveYear($year)
    {
        $this->moveMonth((int)$year * 12);
    }

    /**
     * ꤵ줿ư
     * 
     * @param  int  $month ư
     * @return void
     * @access public
     */
    function moveMonth($month)
    {
        $repeat_num = (int)$month;

        if ($repeat_num < 0) {
            // ʢ
            $this->_reverseMonth(abs($repeat_num));
        } elseif ($repeat_num > 0) {
            // ʹߤ˿ʤʢ
            $this->_advanceMonth($repeat_num);
        }
    }

    /**
     * ꤵ줿ư
     * 
     * @param  int  $week ư뽵
     * @return void
     * @access public
     */
    function moveWeek($week)
    {
        $this->_addTime((int)$week * WEEK);
    }

    /**
     * ꤵ줿ư
     * 
     * @param  int  $day ư
     * @return void
     * @access public
     */
    function moveDay($day)
    {
        $this->_addTime((int)$day * DAY);
    }

    /**
     * ν˰ư
     * 
     * @param  void
     * @param  void
     * @access public
     */
    function moveFirstDay()
    {
        $this->setTime(strtotime(date('Y-m-1 H:i:s', $this->getTime())));
    }

    /**
     * κǽ˰ư
     * 
     * @param  void
     * @param  void
     * @access public
     */
    function moveLastDay()
    {
        $this->setTime(strtotime(date('Y-m-t H:i:s', $this->getTime())));
    }

    /**
     * 콵ܤ˰ư
     * 
     * @param  void
     * @param  void
     * @access public
     */
    function moveFirstWeek()
    {
        for ($i = $this->getDay(); $i > 0; $i -= 7);
        $this->setTime(strtotime(date('Y-m-'.($i+7).' H:i:s', $this->getTime())));
    }

    /**
     * ॹפû
     * 
     * @param  integer $timestamp û륿ॹ
     * @return void 
     * @access private
     */
    function _addTime($timestamp)
    {
        $this->setTime($this->getTime() + (int)$timestamp);
    }


    /**
     * ʬʹߤ˷ʤ
     * 
     * @param  int  $repeat ֤ʿʤ
     * @return void
     * @access private
     */
    function _advanceMonth($repeat)
    {
        $original_time = $this->getTime();

        for ($i = 1, $n = (int)$repeat; $i <= $n; ++$i) {
            // ñƱλ
            $added_time = strtotime('+'.(string)$i.'month', $original_time);

            // ν˰ư
            $this->moveLastDay();
            $this->moveDay(1);

            // Ʊλ̤ˤʤäƤС
            // ɾǤΤǷ̤񤭤
            // --------------------------------------------------
            // ȷ̤ˤʤʤˤϡ
            // ȯƤΤذưƽλ
            // --------------------------------------------------
            if ((int)date('n', $added_time) === $this->getMonth()) {
                $this->setTime($added_time);
            } else {
                $this->moveLastDay();
            }
        }
    }

    /**
     * ʬ˷᤹
     * 
     * @param  int  $repeat ֤
     * @return void
     * @access private
     */
    function _reverseMonth($repeat)
    {
        $original_time = $this->getTime();

        for ($i = 1, $n = (int)$repeat; $i <= $n; ++$i) {
            // ñƱλ
            $deducted_time = strtotime('-'.(string)$i.'month', $original_time);

            // ˰ư
            $this->moveFirstDay();
            $this->moveDay(-1);

            // Ʊλ̤ˤʤäƤС
            // ɾǤΤǷ̤񤭤
            // --------------------------------------------------
            // ȷ̤ˤʤʤˤϡ
            // ȯƤΤذưޤ޽λ
            // --------------------------------------------------
            if ((int)date('n', $deducted_time) === $this->getMonth()) {
                $this->setTime($deducted_time);
            }
        }
    }
}
