<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/* @use Module_FunctionLoader */
require_once 
    dirname(dirname(__FILE__)) . DS . 'FunctionLoader.class.php';

/* 顼ɡ⥸塼뵡ǽ˼ */
define('MODULE_EXECUTANT_ERROR_FUNCTION_CREATE', 303);

/**
 * ⥸塼ݥ饹
 * - ⥸塼ϤΥ饹ѾƵǽ
 * - ⥸塼̾ƤС⥸塼Ȥư
 * - ­ΰտޤϡˤʤʸ󥳡ǥ󥰾ͭ
 *  - ƤνܸΥޥХȤεưڤΥʤΤ
 * 
 * @package    tima
 * @version    SVN: $Id: AbstractExecutant.class.php 4 2007-06-20 07:16:44Z do_ikare $
 * @abstract
 */
class Module_Executant_AbstractExecutant
{

    /**
     * ⥸塼̾
     * 
     * @var    string
     * @access protected
     */
    var $moduleName = '';

    /**
     * ʸ󥳡ǥ
     * 
     * @var    string|null
     * @access protected
     */
    var $internalEncoding = null;

    /**
     * ⥸塼뵡ǽΥ饹̾
     * 
     * @var    array
     * @access private
     */
    var $_functionNames = array();

    /**
     * ⥸塼뵡ǽΥ󥹥
     * 
     * @var    array
     * @access private
     */
    var $_functions  = array();

    /**
     * 󥹥ȥ饯
     * 
     * @param  void
     * @access public
     */
    function Module_Executant_AbstractExecutant()
    {
        $module_prefix = $this->moduleName . '_';
        $prefix_length = strlen($module_prefix);

        foreach (Module_FunctionLoader::factory($this->moduleName) as $class_name) {
            if (strpos($class_name, $module_prefix) !== 0) {
                continue;
            }
            $function_name = strtolower(substr($class_name, $prefix_length));
            $this->_functionNames[$function_name] = $class_name;
        }
    }

    /**
     * ⥸塼εǽ¹
     * 
     * @param  string     $function_name ⥸塼뵡ǽ̾
     * @param  mixed      $attributes    ¹оݤ
     * @param  array|null $params        ¹ԥץ
     * @return mixed ¹Է
     * @access protected
     * @see    Module_Executant_AbstractExecutant::factory()
     * @final
     */
    function execute($function_name, $attributes, $params = null)
    {
        $function  = &$this->factory($function_name);
        $resultant = null;

        if (isset($function) && method_exists($function, 'execute')) {
            $resultant = $function->execute($attributes, $params);
        }

        return $resultant;
    }

    /**
     * ⥸塼εǽֵ
     * 
     * @param  string $function_name ⥸塼뵡ǽ̾
     * @return ModuleFunction
     * @final
     * @access public
     * @see    Module_Executant_AbstractExecutant::exists()
     */
    function &factory($function_name)
    {
        if (!is_string($function_name) || ($function_name === '')) {
            $function = null;
            return $function;
        }

        $subset_name = strtolower($function_name);
        if (!$this->exists($subset_name)) {
            $function = null;
            return $function;
        }

        if (!isset($this->_functions[$subset_name])) {
            $this->_functions[$subset_name] = 
                &new $this->_functionNames[$subset_name]($this);
        }

        return $this->_functions[$subset_name];
    }

    /**
     * ⥸塼뵡ǽѲǽ
     * 
     * @param  string  $function_name ⥸塼뵡ǽ̾
     * @return boolean
     * @final
     * @access public
     */
    function exists($function_name)
    {
        return
            (is_string($function_name) && ($function_name !== '') && 
             array_key_exists(strtolower($function_name), $this->_functionNames));
    }

    /**
     * ⥸塼뵡ǽ̾ΰֵ
     * 
     * @param  void
     * @return array  ⥸塼뵡ǽ̾ΰ
     * @final
     * @access public
     */
    function names()
    {
        return array_keys($this->_functionNames);
    }

    /**
     * ʸ󥳡ǥ󥰤ֵ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getInternalEncoding()
    {
        if (!isset($this->internalEncoding)) {
            $this->internalEncoding = mb_internal_encoding();
        }

        return $this->internalEncoding;
    }

    /**
     * ʸ󥳡ǥ󥰤Ͽ
     * 
     * @param  string  $encoding
     * @return void
     * @access public
     */
    function setInternalEncoding($encoding)
    {
        $this->internalEncoding = $encoding;
    }
}
