<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/* @use Module_Executant_AbstractExecutant */
require_once 
    dirname(__FILE__) . DS . 'AbstractExecutant.class.php';

/**
 * ʸѴ⥸塼
 * 
 * @package    tima
 * @subpackage tima_Converter
 * @version    SVN: $Id: Converter.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Module_Executant_Converter extends Module_Executant_AbstractExecutant
{

    /**
     * ⥸塼̾
     * 
     * @var    string
     * @access protected
     */
    var $moduleName = 'Converter';

    /**
     * СѴֵ̤
     * 
     * @param  string  $converter_name С̾
     * @param  string  $attributes     Ѵ
     * @return string
     * @access public
     * @see    Module_Executant_AbstractExecutant::execute()
     */
    function to($converter_name, $attributes)
    {
        return $this->execute($converter_name, (string)$attributes);
    }

    /**
     * ľѴͤ˱ƶͿ򸡺
     * 
     * @param  string  $converter_name С̾
     * @return boolean
     * @access public
     * @see    Module_Executant_AbstractExecutant::factory()
     */
    function isConverted($converter_name)
    {
        $function = &$this->factory($converter_name);

        if (is_null($function) || !method_exists($function, 'isConverted')) {
            return false;
        }

        return $function->isConverted();
    }

    /**
     * ޥХʸѴ
     * mb_convert_kana()ؿΥ硼ȥå
     * 
     * @param  string $attribute Ѵʸ
     * @param  string $option    Ѵץ
     * @return string
     * @access public
     */
    function toKana($attribute, $option)
    {
        return mb_convert_kana($attribute, $option, $this->getInternalEncoding());
    }
}
