<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * ʸ󤬤뤳ȡʶʸʳ1ʸʾ夢뤳ȡˤ򸡾
 * 
 * @package    tima
 * @subpackage tima_Validator
 * @version    SVN: $Id: Required.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Validator_Required extends Validator_AbstractValidator
{

    /**
     * ʸ󤬤뤳ȡʶʸʳ1ʸʾ夢뤳ȡˤ򸡾
     * 
     * ʸ򥫥Ȥơ̤ʸʾǤп֤
     * ܸĶˡʸΥȤˤmbؿ
     * 
     * $paramsפͤư
     * - ȤʸʥǥեȤϲԤȥ֤Ⱦѥڡ
     *  - Ȥ̤trim()ؿζޤ
     * 
     * @param  string     $attribute
     * @param  array|null $params
     * @return boolean
     * @access protected
     */
    function doFunction($attribute, $params)
    {
        $search = array("\r\n", "\n", "\r", "\t", ' ');
        if (is_array($params) && !empty($params)) {
            $search = $params;
        }

        return (
            mb_strlen(
                str_replace($search, '', trim($attribute)), 
                $this->module->getInternalEncoding()) > 0);
    }
}
