<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * ¹ԥץ
 * 
 * @package  tima
 * @version  SVN: $Id: Process.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Process
{

    /**
     * 󡦥
     * 
     * @var    action
     * @access private
     */
    var $_task = null;

    /**
     * ¹Ԥ륢̾
     * 
     * @var    string
     * @access private
     */
    var $_action = '';

    /**
     * 󡦥ȥΥѥ
     * 
     * @var    string
     * @access private
     */
    var $_path = '';

    /**
     * 󥹥ȥ饯
     * 
     * @param  void
     * @access public
     */
    function Process() {}

    /**
     * Ͽ
     * 
     * @param  Action $task   󡦥ȥ
     * @param  string $action ¹Ԥ륢̾
     * @param  array  $path   󡦥ȥ顦饹Υѥ
     * @return void
     * @access public
     * @see    Action::enabled()
     * @see    Action::getDefaultAction()
     * @see    Action::isActionExists()
     */
    function set(&$task, $action, $path)
    {
        $this->_task   = &$task;
        $this->_action = $action;
        $this->_path   = $path;
    }

    /**
     * ¹
     * 
     *  - 󡦥ȥ餫¹Ը¤ʤä
     *   - 顼Forbidden executing action-controller 'ȥ̾'
     *   - 쥹ݥ󥹡403 Forbidden
     *  - 󡦥ȥ˥¸ߤʤ
     *   - 顼Action 'ȥ̾::̾' not found
     *   - 쥹ݥ󥹡404 Not Found
     * 
     * @param  void
     * @return string|null
     * @access public
     */
    function invoke()
    {
        $this->_task->initialize();

        // ̾ʤХǥեͤ򥻥å
        if ($this->_action === null) {
            $this->_action = $this->_task->getDefaultAction();
        }

        if (!$this->_task->isActionExists($this->_action)) {
            header('HTTP/1.0 400 Bad Request');
            // ץΥ顼ǤϤʤΤPHPΥ顼ȯʤ٤
            // ʽη̤Ȥƥȥ¦ǥϿ롩
            trigger_error(
                sprintf(
                    "Action '%s::%s' not found", 
                    $this->_task->getName(), $this->_action), 
                E_USER_ERROR);
            exit;
        }

        if (!$this->_task->enable()) {
            header('HTTP/1.0 403 Forbidden');
            // ץΥ顼ǤϤʤΤPHPΥ顼ȯʤ٤
            // ʽη̤Ȥƥȥ¦ǥϿ롩
            trigger_error(
                sprintf(
                    "Forbidden executing action-controller '%s'", 
                    $this->_task->getName()), 
                E_USER_ERROR);
            exit;
        }

        $resultant = $this->_task->invoke($this->_action);
        if (($resultant === null) || ($resultant === 'success')) {
            $resultant = $this->_action;
        }

        return $this->_formatResult($resultant);
    }

    /**
     * ¹Է̤Υѥƹ
     * 
     * @param  string $resultant ̥ѥ
     * @param  array  $path      󡦥ȥ顦饹Υѥ
     * @return string|null
     * @access public
     */
    function _formatResult($resultant)
    {
        if (!is_string($resultant) || ($resultant === '')) {
            return '';
        }

        // ̥ѥ̿ҡ::פޤޤƤкƹɬפʤ
        if (strpos($resultant, '::') !== false) {
            return $resultant;
        }

        // ̥ѥƬ/פʤ顢Υ󥻥ŪȽ
        // ˥ѥлꤹʤƥץ졼Ȥͤ
        $resultant = str_replace('/', DS, $resultant);
        if ((strpos($resultant, DS) === 0)) {
            return substr($resultant, 1);
        }

        // ̥ѥƹ
        $action_path = $this->_path['ctrl'];
        if ($this->_path['dir'] !== '') {
            if (strrpos($this->_path['dir'], DS) !== strlen($this->_path['dir'])) {
                $this->_path['dir'] = $this->_path['dir'] . DS;
            }
            $action_path = $this->_path['dir'] . $action_path;
        }

        return $action_path . DS . $resultant;
    }
}
