<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * 饤ȤΥꥯȾ
 * 
 * @package  tima
 * @version  SVN: $Id: Request.class.php 4 2007-06-20 07:16:44Z do_ikare $
 * @todo     URI|URL|pathۣ˻ȤʬƤΤ
 */
class Request
{

    /**
     * ꥯ
     * 
     * @var    array
     * @access private
     */
    var $_parameters = array();

    /**
     * 󥹥ȥ饯
     * 
     * ꥯѿϰǻꤵ줿᥽åɤͭˤʤ
     * ά줿ˤϥꥯȡ᥽åɤΤߤоݤˤ
     * 
     * - g: $_GET
     * - p: $_POST
     * - c: $_COOKIE
     * - q: $_SERVER['QUERY_STRING']
     *  - URL󥳡ɤ줿ޤޤΥʸ
     * 
     * @param  array $method ᥽å̾
     * @access public
     */
    function Request($method = null)
    {
        if ($method === null) {
            switch (true) {
            case $this->isPost() : 
                $method = array('p');
                break;
            case $this->isGet() : 
                $method = array('g');
                break;
           default : 
                $method = array();
                break;
            }
        }
       if (!is_array($method)) {
           $method = (array)$method;
       }

        foreach ($method as $section) {
            switch ($section) {
            case 'g' : 
                foreach ($_GET as $varkey => $varvalue) {
                    if (strrpos($varkey, '_x') === (strlen($varkey) - 2)) {
                        $varvalue = array('x' => $varvalue);
                    } elseif (strrpos($varkey, '_y') === (strlen($varkey) - 2)) {
                        $varvalue = array('y' => $varvalue);
                    }
                    $this->set($varkey, $varvalue);
                }
                break;
            case 'p' : 
                foreach ($_POST as $varkey => $varvalue) {
                    if (strrpos($varkey, '_x') === (strlen($varkey) - 2)) {
                        $varvalue = array('x' => $varvalue);
                    } elseif (strrpos($varkey, '_y') === (strlen($varkey) - 2)) {
                        $varvalue = array('y' => $varvalue);
                    }
                    $this->set($varkey, $varvalue);
                }
                break;
            case 'c' : 
                foreach ($_COOKIE as $varkey => $varvalue) {
                    $this->set($varkey, $varvalue);
                }
                break;
            case 'q' : 
                if (!isset($_SERVER['QUERY_STRING'])) {
                    break;
                }
                foreach (explode('&', $_SERVER['QUERY_STRING']) as $query) {
                    $query    = split('=', $query);
                    $varkey   = $query[0];
                    $varvalue = (isset($query[1]) ? $query[1] : null);
                    if ($varkey === '') {
                        continue;
                    }
                    $this->set($varkey, $varvalue);
                }
                break;
            }
        }
    }

    /**
     * ΥꥯͤϿ
     * 
     * ϿƤСͤΥޡߤ
     * 1. GETѿ$bפarray(1,2,3)
     * 2. POSTѿ$bפʸhoge
     * 3. åȤϡGETPOST
     * 4. Ͽͤϡarray(1,2,3,hoge)
     * 
     * @param  string $varkey   ꥯȥ
     * @param  mixed  $varvalue ꥯ
     * @return void
     * @access public
     */
    function set($varkey, $varvalue)
    {
        // if (isset($this->_parameters[$varkey]) && 
        //     is_array($this->_parameters[$varkey])) {
        //     $varvalue = Utility::merge(
        //         $this->_parameters[$varkey], (array)$varvalue);
        // }
        $this->_parameters[$varkey] = $varvalue;
    }

    /**
     * Υꥯֵͤ
     * 
     * @param  string $varkey ꥯȥ
     * @return mixed
     * @access public
     */
    function get($varkey)
    {
        if (!is_string($varkey) || ($varkey === '')) {
            return null;
        }
        if (!isset($this->_parameters[$varkey])) {
            return null;
        }

        return $this->_parameters[$varkey];
    }

    /**
     * ƤΥꥯֵͤ
     * 
     * @param  void
     * @return array
     * @access public
     */
    function getAll()
    {
        return $this->_parameters;
    }

    /**
     * ꤷ᥽åɤλѿ̾Υꥯֵͤ
     * 
     * - ꥯȡ᥽åɰʳΥꥯͤľܥ
     * - оݤΥꥯͤϥ᥽å̾ɾꤹ뤳ȤǤ
     *  - ǥեȤǤϡGETPOSTפνɾ
     * 
     * @param  string $varkey ꥯȥ
     * @param  array  $order  ᥽åɤ̾
     * @return mixed
     * @access public
     */
    function getAcceptRequest($varkey, $order = array('g', 'p'))
    {
        $varvalue = null;

        if (!is_array($order)) {
            $order = array();
        }
        foreach ($order as $method) {
            // ͤnullʤ¸ߤʤΤȽǤ
            switch ($method) {
            case 'g' : 
                if (isset($_GET[$varkey])) {
                    $varvalue = $_GET[$varkey];
                }
                break;
            case 'p' : 
                if (isset($_POST[$varkey])) {
                    $varvalue = $_POST[$varkey];
                }
                break;
            case 'c' : 
                if (isset($_COOKIE[$varkey])) {
                    $varvalue = $_COOKIE[$varkey];
                }
                break;
            case 'f' : 
                if (isset($_FILES[$varkey])) {
                    $varvalue = $_FILES[$varkey];
                }
                break;
            case 'q' : 
                if (!isset($_SERVER['QUERY_STRING'])) {
                    break;
                }
                foreach (explode('&', $_SERVER['QUERY_STRING']) as $query) {
                    $query       = split('=', $query);
                    $query_name  = $query[0];
                    $query_value = (isset($query[1]) ? $query[1] : null);
                    if ($query_name === $varkey) {
                        if (isset($query_value)) {
                            $varvalue = $query_value;
                        }
                        break;
                    }
                }
                break;
            }
        }

        return $varvalue;
    }

    /**
     * ĶѿPATH_INFOϢֵ
     * 
     * - /example.php/foo/1/bar/2/hoge/3 => array('foo'=>1, 'bar'=>2, 'hoge'=>3)
     * 
     * @param  void
     * @return array
     * @access public
     */
    function getPathInfo()
    {
        $request = $this->getEnv('PATH_INFO');
        if ($request === null) {
            $request = $this->getEnv('ORIG_PATH_INFO');
        }
        if ($request === null) {
            $request = '';
        }
        $query     = explode('/', trim($request, '/'));
        $path_info = array();
        for ($i = 0; $i < count($query); $i += 2) {
            $path_info[$query[$i]] = 
                (isset($query[$i + 1]) ? $query[$i + 1] : null);
        }

        return $path_info;
    }

    /**
     * ꤵ줿ѿ̾ΥꥯȤ¸ߤ뤫򸡺
     * 
     * @param  string $varkey ꥯȥ
     * @return boolean
     * @access public
     */
    function exists($varkey)
    {
        // ͤnullΥꥯȤϡ¸ߤʤפɾ
        // ͤnullϿȤ԰٤¸ߤõΤȹͤ
        return 
            isset($this->_parameters[$varkey]);
    }

    /**
     * ꥯȤѿֵ̾
     * 
     * @param  void
     * @return array
     * @access public
     */
    function getNames()
    {
        return 
            array_keys($this->_parameters);
    }

    /**
     * Ķѿֵͤ
     * - ʸƽ뤿ᡢͤƶǽ
     * 
     * @param  string $varkey
     * @return string|null
     * @static string $ctrl_cahr
     * @access public
     */
    function getEnv($varkey)
    {
        static $ctrl_char;
        if (!isset($ctrl_char)) {
            $ctrl_char = 
                array("\x00", "\x01", "\x02", "\x03", "\x04", "\x05", "\x06", 
                      "\x07", "\x08", "\x09", "\x0A", "\x0B", "\x0C", "x\0D", 
                      "\x0E", "\x0F", "\x10", "\x11", "\x12", "\x13", "\x14", 
                      "\x15", "\x16", "\x17", "\x18", "\x19", "\x1A", "\x1B", 
                      "\x1C", "\x1D", "\x1E", "\x1F", "\x7F");
        }

        $varvalue = 
            isset($_SERVER[$varkey]) ? 
                str_replace($ctrl_char, '', $_SERVER[$varkey]) : null;

        return $varvalue;
    }

    /**
     * ꥯȤ줿ۥȥФֵ̾
     * - ꥯȥإåΡhostפ
     *  - HTTP/1.0Ǥ¸ߤʤ
     *  - HTTP/1.1ǤꥯȤˤäƤ¸ߤʤ
     *  - ꥯȤ˥ݡֹ椬Хݡֹޤ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getHost()
    {
        $host = $this->getEnv('HTTP_X_FORWARDED_HOST');
        if ($host === null) {
            $host = $this->getEnv('HTTP_HOST');
        }
        if ($host === null) {
            $host = '';
        }

        return $host;
    }

    /**
     * ꥽ΥۥȡФֵ̾
     * - ФꤵƤ̾
     *  - ApacheǤСServerNameץǥ쥯ƥ֤
     *  - СۥȤǤϥФˤäƤ
     *    Request::getHost()ͤȰۤʤǽ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getServerName()
    {
        $server_name = $this->getEnv('HTTP_X_FORWARDED_SERVER');
        if ($server_name === null) {
            $server_name = $this->getEnv('SERVER_NAME');
        }
        if ($server_name === null) {
            $server_name = '';
        }

        return $server_name;
    }

    /**
     * ե顼ֵ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getReferer()
    {
        $referer = $this->getEnv('HTTP_REFERER');
        if ($referer === null) {
            $referer = '';
        }

        return $referer;
    }

    /**
     * ¹ԤƤ륹ץȤΥɥȥ롼ȤΥѥֵ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getScriptName()
    {
        $script_name = $this->getEnv('SCRIPT_NAME');
        if ($script_name === null) {
            $script_name = $this->getEnv('ORIG_SCRIPT_NAME');
        }
        if ($script_name === null) {
            $script_name = '';
        }

        return $script_name;
    }

    /**
     * ¹ԤƤmainȤʤäƤ˥ץȤΥѥֵ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getMainPath()
    {
        $script_filename = $this->getEnv('SCRIPT_FILENAME');
        if ($script_filename === null) {
            $script_filename = $this->getEnv('ORIG_SCRIPT_FILENAME');
        }
        if ($script_filename === null) {
            $script_filename = '';
        }

        return $script_filename;
    }

    /**
     * ꥽Υֵ
     * - http:
     * - https:
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getScheme()
    {
        $scheme = ($this->isSecure() ? 'https:' : 'http:');

        return $scheme;
    }

    /**
     * ꥽ΥȥۥȤֵ̾
     * - http://example.com
     * - https://example.com
     * - http://example.com:8080
     * 
     * @param  void
     * @return string
     * @access public
     * @todo ͥŪˡHTTP_HOSTפͤѤΤǡ
     *       ݡֹ椬ȤƤȡhttp://example.com:8080:8080
     *       ȤֵͤѤǽΤ׽
     */
    function getHostUri()
    {
        $host_name = $this->getHost();
        if ($host_name === '') {
            $host_name = $this->getServerName();
        }
        $host_uri = $this->getScheme() . '//' . $host_name;
        $std_port = ($this->isSecure() ? '443' : '80');
        $port_no  = $this->getEnv('SERVER_PORT');
        if (isset($port_no) && ($port_no !== '') && ($port_no !== $std_port)) {
            $host_uri .= ':' . $port_no;
        }

        return $host_uri;
    }

    /**
     * ꥽Υѥֵ
     * - /foo/bar/hoge.html
     * - /foo/bar/
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getPathUri()
    {
        $path = $this->getEnv('REQUEST_URI');
        if ($path === null) {
            $path = '';
        }
        if (preg_match('/^(?:http)(?:s)?:\/\//', $path)) {
            $url  = parse_url($path);
            $path = $url['path'];
        }
        if (($i = strpos($path, '?')) !== false) {
            $path = substr($path, 0, $i);
        }

        return $path;
    }

    /**
     * ꥽URLֵ
     * - http://example.com/
     * - https://example.com/foo/bar/
     * - http://example.com:8080/foo/bar/hoge.html
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getUrl()
    {
        $url = $this->getHostUri() . $this->getPathUri();

        return $url;
    }

    /**
     * ꥯȡ᥽åɤֵ
     * - GET
     * - POST
     * - PUT
     * - DELETE
     * - HEAD
     * - ʳΥ᥽åɤϡGETפˤ
     *
     * @param  void
     * @return string
     * @access public
     */
    function getMethod()
    {
        $method = $this->getEnv('REQUEST_METHOD');
        switch ($method) {
        case 'GET' : 
        case 'POST' : 
        case 'PUT' : 
        case 'DELETE' : 
        case 'HEAD' : 
            break;
        default : 
            $method = 'GET';
        }

        return $method;
    }

    /**
     * ꥯȤΥ᥽åɤGETפ򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isGet()
    {
        return 
            ($this->getMethod() === 'GET');
    }

    /**
     * ꥯȤΥ᥽åɤPOSTפ򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isPost()
    {
        return 
            ($this->getMethod() === 'POST');
    }

    /**
     * ꥯȤΥ᥽åɤPUTפ򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isPut()
    {
        return 
            ($this->getMethod() === 'PUT');
    }

    /**
     * ꥯȤΥ᥽åɤDELETEפ򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isDelete()
    {
        return 
            ($this->getMethod() === 'DELETE');
    }

    /**
     * ꥯȤΥ᥽åɤHEADפ򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isHead()
    {
        return 
            ($this->getMethod() === 'HEAD');
    }

    /**
     * ꥯȤHTTPSץȥˤŹ̿򸡺
     *
     * @param  void
     * @return boolean
     * @access public
     */
    function isSecure()
    {
        return (
            ($this->getEnv('HTTPS') === 'on') || 
            ($this->getEnv('HTTP_X_FORWARDED_PROTO') === 'https'));
    }
}
