/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;

public class SBDPrint
implements Printable {
    SBDTableModel model;
    Font m_font = null;
    double gWidth;
    double gHeight;
    double topLine;
    double bottomLine;
    double headLine;
    double[] hlinesY;
    double cutX;
    double picX;
    double expX;
    double wordX;
    double secX;

    public void selectFont() {
    }

    public void print(SBDTableModel p) {
        this.model = p;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(MediaSizeName.ISO_A4);
        aset.add(OrientationRequested.PORTRAIT);
        aset.add(new JobName(this.model.getTitle(), null));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, aset);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, aset);
        if (service != null) {
            System.out.println("selected printer " + service.getName());
            DocPrintJob pj = service.createPrintJob();
            try {
                SimpleDoc doc = new SimpleDoc(this, flavor, null);
                PrintJobAdapter listener = new PrintJobAdapter(){

                    public void printDataTransferCompleted(PrintJobEvent e) {
                        System.out.println("\u5370\u5237\u5b8c\u4e86");
                    }
                };
                pj.addPrintJobListener(listener);
                pj.print(doc, aset);
            }
            catch (PrintException e) {
                System.err.println(e);
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            System.out.println("PrintX=" + pf.getImageableWidth() + " Y=" + pf.getImageableHeight());
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.setColor(Color.black);
            if (this.m_font != null) {
                g2d.setFont(this.m_font);
            }
            this.gWidth = pf.getImageableWidth();
            this.gHeight = pf.getImageableHeight();
            FontMetrics fm = g2d.getFontMetrics();
            int h = fm.getHeight();
            double wakuh = this.gWidth * 0.25875;
            int bun = (int)(this.gHeight / wakuh);
            this.hlinesY = new double[bun];
            this.bottomLine = wakuh * (double)bun;
            this.topLine = (double)h + (this.gHeight - this.bottomLine) / 2.0;
            this.headLine = this.topLine + (double)h;
            int i = 0;
            while (i < bun) {
                this.hlinesY[i] = (double)i * wakuh + this.headLine;
                ++i;
            }
            this.bottomLine += this.headLine;
            this.secX = this.gWidth - this.gWidth * 0.051;
            this.wordX = this.gWidth - this.gWidth * 0.102;
            this.cutX = this.gWidth * 0.051;
            this.picX = this.gWidth * 0.396;
            this.expX = this.gWidth * 0.6629999999999999;
            this.printFrame(g2d, pf, pageIndex);
            return 0;
        }
        return 1;
    }

    private void printFrame(Graphics2D g2d, PageFormat pf, int pageIndex) {
        FontMetrics fm = g2d.getFontMetrics();
        int h = fm.getHeight();
        g2d.drawString("\u300c" + this.model.getTitle() + "\u300d\u3000" + pageIndex + "\u30da\u30fc\u30b8", 0, h);
        g2d.drawLine(0, (int)this.topLine, 0, (int)this.bottomLine);
        g2d.drawLine((int)this.gWidth, (int)this.topLine, (int)this.gWidth, (int)this.bottomLine);
        g2d.drawLine((int)this.secX, (int)this.topLine, (int)this.secX, (int)this.bottomLine);
        g2d.drawLine((int)this.wordX, (int)this.topLine, (int)this.wordX, (int)this.bottomLine);
        g2d.drawLine((int)this.cutX, (int)this.topLine, (int)this.cutX, (int)this.bottomLine);
        g2d.drawLine((int)this.picX, (int)this.topLine, (int)this.picX, (int)this.bottomLine);
        g2d.drawLine((int)this.expX, (int)this.topLine, (int)this.expX, (int)this.bottomLine);
        g2d.drawLine(0, (int)this.topLine, (int)this.gWidth, (int)this.topLine);
        g2d.drawLine(0, (int)this.headLine, (int)this.gWidth, (int)this.headLine);
        int i = 0;
        while (i < this.hlinesY.length) {
            g2d.drawLine(0, (int)this.hlinesY[i], (int)this.gWidth, (int)this.hlinesY[i]);
            ++i;
        }
        g2d.drawLine(0, (int)this.bottomLine, (int)this.gWidth, (int)this.bottomLine);
    }
}

