/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class sbedit
extends JFrame
implements ActionListener {
    String VERSION_STR = "\u7d75\u30b3\u30f3\u30c6\u30a8\u30c7\u30a3\u30bf\n2003/10/23\u7248\nhttp://www.mapletown.net/~nekora/";
    SBDTableModel model;
    SDBTable table;
    String myfilename;
    String lastloadimage = null;
    boolean editing = false;
    Integer window_px;
    Integer window_py;
    Integer window_sx;
    Integer window_sy;
    int window_default_iconsize;
    ArrayList clipboard;
    String execpath;
    String workroot;
    String docwork;
    String[] strMenuItemFile = new String[]{"\u65b0\u898f\u4f5c\u6210(N)", "\u958b\u304f(O)", "\u4e0a\u66f8\u304d\u4fdd\u5b58(S)", "\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58(A)", "\u5370\u5237(P)", "\u30d7\u30ed\u30d1\u30c6\u30a3(R)", "\u7d42\u4e86(X)"};
    String[] strMenuItemEdit = new String[]{"\u5207\u308a\u53d6\u308a(T)", "\u30b3\u30d4\u30fc(C)", "\u8cbc\u308a\u4ed8\u3051(P)", "\u884c\u8ffd\u52a0(A)", "\u884c\u633f\u5165(I)", "\u884c\u524a\u9664(D)", "\u4f59\u767d\u524a\u9664(Y)"};
    String[] strMenuItemView = new String[]{"\u5927(B)", "\u4e2d(M)", "\u5c0f(S)"};
    String[] strMenuItemBookMark = new String[]{"\u8ffd\u52a0(A)", "\u6574\u7406(O)"};
    String[] strMenuItemTool = new String[]{"HTML\u51fa\u529b(H)", "TMS\u51fa\u529b(S)", "\u8a2d\u5b9a(O)"};
    String[] strMenuItemHelp = new String[]{"\u76ee\u6b21\u3068\u30ad\u30fc\u30ef\u30fc\u30c9(C)", "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831(V)"};
    final int intMenuEdit = 1;
    final int intMenuInsertLine = 4;
    final int intMenuDeleteLine = 5;
    char[] charMenuItemFile = new char[]{'N', 'O', 'S', 'A', 'P', 'R', 'X'};
    char[] charMenuItemEdit = new char[]{'T', 'C', 'P', 'A', 'I', 'D', 'Y'};
    char[] charMenuItemView = new char[]{'B', 'M', 'S'};
    char[] charMenuItemBookMark = new char[]{'A', 'O'};
    char[] charMenuItemTool = new char[]{'H', 'T', 'O'};
    char[] charMenuItemHelp = new char[]{'C', 'V'};
    JMenuItem[] itemFile = new JMenuItem[this.strMenuItemFile.length];
    JMenuItem[] itemEdit = new JMenuItem[this.strMenuItemEdit.length];
    JMenuItem[] itemView = new JMenuItem[this.strMenuItemView.length];
    JMenuItem[] itemBookMark = new JMenuItem[this.strMenuItemBookMark.length];
    JMenuItem[] itemTool = new JMenuItem[this.strMenuItemTool.length];
    JMenuItem[] itemHelp = new JMenuItem[this.strMenuItemHelp.length];
    int oldPos;
    int times = 0;
    static /* synthetic */ Class class$0;

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.itemFile[0]) {
            this.MenuFileNew();
        } else if (evt.getSource() == this.itemFile[1]) {
            this.MenuFileOpen();
        } else if (evt.getSource() == this.itemFile[2]) {
            this.MenuFileSave();
        } else if (evt.getSource() == this.itemFile[3]) {
            this.MenuFileSaveNew();
        } else if (evt.getSource() == this.itemFile[4]) {
            this.MenuFilePrint();
        } else if (evt.getSource() == this.itemFile[5]) {
            this.MenuFileProperty();
        } else if (evt.getSource() == this.itemFile[6]) {
            this.MenuFileExit();
        } else if (evt.getSource() == this.itemEdit[0]) {
            this.MenuEditCutLine();
        } else if (evt.getSource() == this.itemEdit[1]) {
            this.MenuEditCopyLine();
        } else if (evt.getSource() == this.itemEdit[2]) {
            this.MenuEditPasteLine();
        } else if (evt.getSource() == this.itemEdit[3]) {
            this.MenuEditAddLine();
        } else if (evt.getSource() == this.itemEdit[4]) {
            this.MenuEditInsertLine();
        } else if (evt.getSource() == this.itemEdit[5]) {
            this.MenuEditDeleteLine();
        } else if (evt.getSource() == this.itemEdit[6]) {
            this.model.removeSpace();
        } else if (evt.getSource() == this.itemView[0]) {
            this.MenuViewBig();
        } else if (evt.getSource() == this.itemView[1]) {
            this.MenuViewMiddle();
        } else if (evt.getSource() == this.itemView[2]) {
            this.MenuViewSmall();
        } else if (evt.getSource() == this.itemBookMark[0]) {
            this.MenuBookMarkAdd();
        } else if (evt.getSource() == this.itemTool[0]) {
            this.MenuToolHTML();
        } else if (evt.getSource() == this.itemHelp[1]) {
            this.MenuHelpVersion();
        } else {
            this.MenuBookMarkJump((JMenuItem)evt.getSource());
        }
    }

    public void MenuFileNew() {
        if (this.editing) {
            String msgtext = "\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u65b0\u898f\u4f5c\u6210\u524d\u306b\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f";
            msgtext = this.myfilename == null ? (this.model.getTitle() == null ? "\u7121\u984c" + msgtext : String.valueOf(this.model.getTitle()) + msgtext) : String.valueOf(this.myfilename) + msgtext;
            int ret = JOptionPane.showConfirmDialog(this.getContentPane(), msgtext, "\u4fdd\u5b58\u78ba\u8a8d", 1);
            if (ret == 0) {
                this.MenuFileSave();
            } else if (ret == 2) {
                return;
            }
        }
        this.myfilename = null;
        this.lastloadimage = null;
        if (this.model != null) {
            this.model.setRowCount(0);
            this.model.clearIcons();
            this.model.clearBookmark();
            this.model.setPos(1, 0);
        }
        Object[][] initRows = new Object[100][7];
        int i = 0;
        while (i < 100) {
            initRows[i][0] = new Integer(i + 1);
            initRows[i][1] = new String("");
            initRows[i][2] = new String("");
            initRows[i][3] = new String("");
            initRows[i][4] = new String("");
            initRows[i][5] = new String("");
            initRows[i][6] = sbedit.makeKeyUID();
            if (this.model != null) {
                this.model.addRow(initRows[i]);
            }
            ++i;
        }
        if (this.model == null) {
            this.model = new SBDTableModel(initRows);
            this.model.setIconSize(this.window_default_iconsize);
            this.model.setTitle("\u7121\u984c");
            this.table = new SDBTable(this.model);
        }
        this.model.renumCutNumber(0);
        this.editing = false;
        this.SetupMenuBookMark();
        this.setTitle("\u300c" + this.model.getTitle() + "\u300d " + this.myfilename);
        this.updateSelection(this.model.getPosY(), this.model.getPosX());
    }

    static String makeKeyUID() {
        UID uid = new UID();
        StringBuffer sb = new StringBuffer(uid.toString());
        int i = 0;
        while (i < sb.length()) {
            if (!Character.isUnicodeIdentifierPart(sb.charAt(i))) {
                sb.setCharAt(i, '_');
            }
            ++i;
        }
        return sb.toString();
    }

    public void MenuFileOpen() {
        if (this.editing) {
            String msgtext = "\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u65b0\u898f\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u524d\u306b\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f";
            msgtext = this.myfilename == null ? (this.model.getTitle() == null ? "\u7121\u984c" + msgtext : String.valueOf(this.model.getTitle()) + msgtext) : String.valueOf(this.myfilename) + msgtext;
            int ret = JOptionPane.showConfirmDialog(this.getContentPane(), msgtext, "\u4fdd\u5b58\u78ba\u8a8d", 1);
            if (ret == 0) {
                this.MenuFileSave();
            } else if (ret == 2) {
                return;
            }
        }
        JFileChooser chooser = this.myfilename != null && this.myfilename.length() > 0 ? new JFileChooser(this.myfilename) : (this.lastloadimage != null && this.lastloadimage.length() > 0 ? new JFileChooser(this.lastloadimage) : new JFileChooser());
        SBDFileFilter filter = new SBDFileFilter();
        filter.addExtension("sbd");
        filter.addExtension("xml");
        filter.setDescription("Story Board Document");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.lastloadimage = null;
            this.myfilename = chooser.getSelectedFile().getPath();
            if (this.model == null) {
                this.model = new SBDTableModel();
                this.table = new SDBTable(this.model);
                this.makeTableScreen();
            } else {
                this.model.setNumRows(0);
                this.model.clearIcons();
            }
            try {
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                Document doc = builder.parse(new BufferedInputStream(new FileInputStream(this.myfilename)));
                this.model.setDocument(doc);
                this.SetupMenuBookMark();
                switch (this.model.getIconSize()) {
                    case 2: {
                        this.MenuViewBig();
                        break;
                    }
                    case 1: {
                        this.MenuViewMiddle();
                        break;
                    }
                    default: {
                        this.MenuViewSmall();
                    }
                }
                this.editing = false;
                this.setTitle("\u300c" + this.model.getTitle() + "\u300d " + this.myfilename);
                this.updateSelection(this.model.getPosY(), this.model.getPosX());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void MenuFileSave() {
        if (this.myfilename == null) {
            this.MenuFileSaveNew();
        } else {
            try {
                int x = this.table.getSelectedColumn();
                int y = this.table.getSelectedRow();
                this.model.setPos(x, y);
                Document xdoc = this.model.getDocument();
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                DOMSource source = new DOMSource(xdoc);
                File newXML = new File(this.myfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                os.flush();
                os.close();
                this.editing = false;
                this.setTitle("\u300c" + this.model.getTitle() + "\u300d " + this.myfilename);
            }
            catch (Exception pce) {
                pce.printStackTrace();
            }
        }
    }

    public void MenuFileSaveNew() {
        if (this.model.getTitle() == null) {
            this.MenuFileProperty();
        }
        JFileChooser chooser = new JFileChooser();
        chooser = this.myfilename != null && this.myfilename.length() > 0 ? new JFileChooser(this.myfilename) : (this.lastloadimage != null && this.lastloadimage.length() > 0 ? new JFileChooser(this.lastloadimage) : new JFileChooser());
        SBDFileFilter filter = new SBDFileFilter();
        filter.addExtension("sbd");
        filter.addExtension("xml");
        filter.setDescription("Story Board Document");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.myfilename = chooser.getSelectedFile().getPath();
            if (this.myfilename.indexOf(".xml") < 0 && this.myfilename.indexOf(".sbd") < 0) {
                this.myfilename = String.valueOf(this.myfilename) + ".xml";
            }
            try {
                int x = this.table.getSelectedColumn();
                int y = this.table.getSelectedRow();
                this.model.setPos(x, y);
                Document xdoc = this.model.getDocument();
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                DOMSource source = new DOMSource(xdoc);
                File newXML = new File(this.myfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                os.flush();
                os.close();
                this.setTitle("\u300c" + this.model.getTitle() + "\u300d " + this.myfilename);
                this.editing = false;
            }
            catch (Exception pce) {
                pce.printStackTrace();
            }
        }
    }

    public void MenuFilePrint() {
        SBDPrint p = new SBDPrint();
        p.selectFont();
        p.print(this.model);
    }

    public void MenuFileProperty() {
        String selectValue = JOptionPane.showInputDialog(this.getContentPane(), "\u4f5c\u54c1\u30bf\u30a4\u30c8\u30eb", "\u30d7\u30ed\u30d1\u30c6\u30a3\u8a2d\u5b9a", 3);
        if (selectValue != null) {
            this.model.setTitle(selectValue);
            this.editing = true;
            this.setTitle("\u300c" + this.model.getTitle() + "\u300d " + this.myfilename);
        }
    }

    public void MenuFileExit() {
        if (this.editing) {
            String msgtext = "\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u7d42\u4e86\u524d\u306b\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f";
            msgtext = this.myfilename == null ? (this.model.getTitle() == null ? "\u7121\u984c" + msgtext : String.valueOf(this.model.getTitle()) + msgtext) : String.valueOf(this.myfilename) + msgtext;
            int ret = JOptionPane.showConfirmDialog(this.getContentPane(), msgtext, "\u4fdd\u5b58\u78ba\u8a8d", 1);
            if (ret == 0) {
                this.MenuFileSave();
            } else if (ret == 2) {
                return;
            }
        }
        this.setExtendedState(0);
        this.savePreferences();
        System.exit(0);
    }

    public void MenuEditCutLine() {
        this.MenuEditCopyLine();
        this.MenuEditDeleteLine();
    }

    public void MenuEditCopyLine() {
        int[] irows = this.table.getSelectedRows();
        if (irows != null) {
            if (this.clipboard == null) {
                this.clipboard = new ArrayList();
            } else {
                this.clipboard.clear();
            }
            int i = irows.length - 1;
            while (i >= 0) {
                int del = irows[i];
                if (del >= this.model.getRowCount() - 1) {
                    del = this.model.getRowCount() - 1;
                }
                Object[] initRows = new Object[]{this.model.getValueAt(del, 0), this.model.getValueAt(del, 1).toString(), this.model.getValueAt(del, 2), this.model.getValueAt(del, 3), this.model.getValueAt(del, 4), this.model.getValueAt(del, 5), this.model.getValueAt(del, 6)};
                this.clipboard.add(initRows);
                --i;
            }
        }
    }

    public void MenuEditPasteLine() {
        int irow = this.table.getSelectedRow();
        if (irow >= 0 && this.clipboard != null) {
            int i = 0;
            while (i < this.clipboard.size()) {
                Object[] rec = (Object[])this.clipboard.get(i);
                this.model.insertRow(irow, rec);
                ++i;
            }
            this.table.setRowSelectionInterval(irow, irow);
            this.model.renumCutNumber(irow);
            this.model.renumTotalTime();
            this.editing = true;
        }
    }

    public void MenuEditDeleteLine() {
        int[] irows = this.table.getSelectedRows();
        if (irows != null) {
            int i = irows.length - 1;
            while (i >= 0) {
                int del = irows[i];
                if (del >= this.model.getRowCount() - 1) {
                    del = this.model.getRowCount() - 1;
                }
                this.model.removeRow(del, true);
                --i;
            }
            this.model.renumCutNumber(irows[0]);
            this.model.renumTotalTime();
            this.editing = true;
        }
    }

    public void MenuEditInsertLine() {
        int irow = this.table.getSelectedRow();
        if (irow >= 0) {
            Object[] rec = new Object[]{new Integer(1), new String(""), new String(""), new String(""), new String(""), new String(""), sbedit.makeKeyUID()};
            this.model.insertRow(irow, rec);
            this.model.renumCutNumber(irow);
            this.model.renumTotalTime();
            this.editing = true;
        }
    }

    public void MenuEditAddLine() {
        String inputValue = JOptionPane.showInputDialog(this.getContentPane(), "\u8ffd\u52a0\u3059\u308b\u884c\u6570", "\u884c\u8ffd\u52a0", 3);
        if (inputValue != null) {
            try {
                Integer i = new Integer(inputValue);
                if (i > 0) {
                    this.addline(i);
                    this.editing = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    int addline(int n) {
        if (n <= 0) {
            return this.model.getRowCount();
        }
        int i = 0;
        while (i < n) {
            Object[] rec = new Object[]{new Integer(1), new String(""), new String(""), new String(""), new String(""), new String(""), sbedit.makeKeyUID()};
            this.model.addRow(rec);
            ++i;
        }
        this.model.renumCutNumber(1);
        this.model.renumTotalTime();
        return this.model.getRowCount();
    }

    public void MenuViewBig() {
        this.table.setRowHeight(480);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.table.getColumnModel();
        TableColumn column = cmodel.getColumn(1);
        column.setMaxWidth(640);
        column.setMinWidth(640);
        column.setPreferredWidth(640);
        this.model.changeIconSize(2);
        this.window_default_iconsize = 2;
    }

    public void MenuViewMiddle() {
        this.table.setRowHeight(240);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.table.getColumnModel();
        TableColumn column = cmodel.getColumn(1);
        column.setMaxWidth(320);
        column.setMinWidth(320);
        column.setPreferredWidth(320);
        this.model.changeIconSize(1);
        this.window_default_iconsize = 1;
    }

    public void MenuViewSmall() {
        this.table.setRowHeight(120);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.table.getColumnModel();
        TableColumn column = cmodel.getColumn(1);
        column.setMaxWidth(160);
        column.setMinWidth(160);
        column.setPreferredWidth(160);
        this.model.changeIconSize(0);
        this.window_default_iconsize = 0;
    }

    public void MenuBookMarkAdd() {
        int irow = this.table.getSelectedRow();
        if (irow >= 0) {
            String selectValue = JOptionPane.showInputDialog(this.getContentPane(), "\u3057\u304a\u308a\u306e\u540d\u524d", "\u3057\u304a\u308a\u8ffd\u52a0", 3);
            if (selectValue == null) {
                return;
            }
            String key = String.valueOf(this.model.getBookMarkSize() + 1) + "." + selectValue;
            this.model.addBookmark(irow, key);
            JMenuBar bar = this.getJMenuBar();
            JMenu menu = bar.getMenu(3);
            JMenuItem itemAdd = new JMenuItem(key);
            menu.add(itemAdd);
            itemAdd.addActionListener(this);
            this.editing = true;
        }
    }

    void MenuBookMarkJump(JMenuItem src) {
        String key;
        int line;
        if (src != null && (line = this.model.getBookmarkRow(key = src.getText())) >= 0) {
            this.updateSelection(line, 0);
        }
    }

    void updateSelection(int rowIndex, int columnIndex) {
        Rectangle cellRect = this.table.getCellRect(rowIndex, columnIndex, false);
        if (cellRect != null) {
            this.table.scrollRectToVisible(cellRect);
        }
        ListSelectionModel rsm = this.table.getSelectionModel();
        ListSelectionModel csm = this.table.getColumnModel().getSelectionModel();
        this.updateSelectionModel(csm, columnIndex);
        this.updateSelectionModel(rsm, rowIndex);
    }

    void updateSelectionModel(ListSelectionModel sm, int index) {
        sm.setSelectionInterval(index, index);
        sm.setLeadSelectionIndex(index);
    }

    void SetupMenuBookMark() {
        Iterator it;
        Set s;
        JMenuBar bar = this.getJMenuBar();
        JMenu menu = bar.getMenu(3);
        int len = menu.getItemCount();
        while (len > 2) {
            menu.remove(2);
            --len;
        }
        if (this.model != null && (s = this.model.getBookmarkKeys()) != null && (it = s.iterator()) != null) {
            while (it.hasNext()) {
                String key = (String)it.next();
                JMenuItem itemAdd = new JMenuItem(key);
                menu.add(itemAdd);
                itemAdd.addActionListener(this);
            }
        }
    }

    public void MenuToolHTML() {
        JFileChooser chooser = new JFileChooser();
        chooser = this.myfilename != null && this.myfilename.length() > 0 ? new JFileChooser(this.myfilename) : (this.lastloadimage != null && this.lastloadimage.length() > 0 ? new JFileChooser(this.lastloadimage) : new JFileChooser());
        SBDFileFilter filter = new SBDFileFilter();
        filter.addExtension("html");
        filter.setDescription("HTML");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            String htmlfilename = chooser.getSelectedFile().getPath();
            String imagedir = htmlfilename.substring(0, htmlfilename.lastIndexOf(46));
            String imagedir2 = htmlfilename.substring(htmlfilename.lastIndexOf(File.separator), htmlfilename.lastIndexOf(46));
            try {
                File f = new File(imagedir);
                f.mkdirs();
                int i = 0;
                while (i < this.model.getRowCount()) {
                    String src = this.model.getValueAt(i, 1).toString();
                    if (src != null && src.length() > 0) {
                        String ext = src.substring(src.lastIndexOf(46));
                        String dst = String.valueOf(imagedir) + File.separator + (String)this.model.getValueAt(i, 6) + ext;
                        FileCopy.copy(src, dst);
                    }
                    ++i;
                }
                FileCopy.copy(String.valueOf(this.execpath) + File.separator + "xsl" + File.separator + "blank.gif", String.valueOf(imagedir) + File.separator + "blank.gif");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            if (htmlfilename.indexOf(".htm") < 0) {
                htmlfilename = String.valueOf(htmlfilename) + ".html";
            }
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                StreamSource xslsrc = new StreamSource(new FileInputStream(String.valueOf(this.execpath) + "xsl\\html.xsl"));
                Transformer transformer = transFactory.newTransformer(xslsrc);
                Properties prop = new Properties();
                prop.setProperty("encoding", "UTF-8");
                transformer.setOutputProperties(prop);
                int saveline = this.model.getRowCount();
                int delline = this.model.removeSpace();
                String[] org_img = new String[this.model.getRowCount()];
                int i = 0;
                while (i < org_img.length) {
                    org_img[i] = this.model.getValueAt(i, 1).toString();
                    if (org_img[i] == null || org_img[i].length() <= 0) {
                        this.model.setValueAt("." + imagedir2 + File.separator + "blank.gif", i, 1);
                    } else {
                        String src = this.model.getValueAt(i, 1).toString();
                        String ext = src.substring(src.lastIndexOf(46));
                        String fname = "." + imagedir2 + File.separator + (String)this.model.getValueAt(i, 6) + ext;
                        this.model.setValueAt(fname, i, 1);
                    }
                    ++i;
                }
                Document xdoc = this.model.getDocument();
                int i2 = 0;
                while (i2 < org_img.length) {
                    this.model.setValueAt(org_img[i2], i2, 1);
                    ++i2;
                }
                this.addline(saveline - delline - 1);
                DOMSource source = new DOMSource(xdoc);
                File newXML = new File(htmlfilename);
                FileOutputStream os = new FileOutputStream(newXML);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                os.flush();
                os.close();
            }
            catch (Exception pce) {
                pce.printStackTrace();
            }
        }
    }

    public void MenuHelpVersion() {
        JOptionPane.showMessageDialog(this.getContentPane(), this.VERSION_STR, "\u7d75\u30b3\u30f3\u30c6\u30a8\u30c7\u30a3\u30bf by \u306d\u3053\u3089", 1);
    }

    void makeMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu menu0 = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menu0.setMnemonic('F');
        int i = 0;
        while (i < this.strMenuItemFile.length) {
            this.itemFile[i] = new JMenuItem(this.strMenuItemFile[i]);
            this.itemFile[i].setMnemonic(this.charMenuItemFile[i]);
            menu0.add(this.itemFile[i]);
            this.itemFile[i].addActionListener(this);
            ++i;
        }
        JMenu menu1 = new JMenu("\u7de8\u96c6(E)");
        menu1.setMnemonic('E');
        int i2 = 0;
        while (i2 < this.strMenuItemEdit.length) {
            this.itemEdit[i2] = new JMenuItem(this.strMenuItemEdit[i2]);
            this.itemEdit[i2].setMnemonic(this.charMenuItemEdit[i2]);
            menu1.add(this.itemEdit[i2]);
            this.itemEdit[i2].addActionListener(this);
            ++i2;
        }
        JMenu menu2 = new JMenu("\u8868\u793a(V)");
        menu2.setMnemonic('V');
        int i3 = 0;
        while (i3 < this.strMenuItemView.length) {
            this.itemView[i3] = new JMenuItem(this.strMenuItemView[i3]);
            this.itemView[i3].setMnemonic(this.charMenuItemView[i3]);
            menu2.add(this.itemView[i3]);
            this.itemView[i3].addActionListener(this);
            ++i3;
        }
        JMenu menu3 = new JMenu("\u3057\u304a\u308a(A)");
        menu3.setMnemonic('A');
        int i4 = 0;
        while (i4 < this.strMenuItemBookMark.length) {
            this.itemBookMark[i4] = new JMenuItem(this.strMenuItemBookMark[i4]);
            this.itemBookMark[i4].setMnemonic(this.charMenuItemBookMark[i4]);
            menu3.add(this.itemBookMark[i4]);
            this.itemBookMark[i4].addActionListener(this);
            ++i4;
        }
        menu3.addSeparator();
        JMenu menu4 = new JMenu("\u30c4\u30fc\u30eb(T)");
        menu4.setMnemonic('T');
        int i5 = 0;
        while (i5 < this.strMenuItemTool.length) {
            this.itemTool[i5] = new JMenuItem(this.strMenuItemTool[i5]);
            this.itemTool[i5].setMnemonic(this.charMenuItemTool[i5]);
            menu4.add(this.itemTool[i5]);
            this.itemTool[i5].addActionListener(this);
            ++i5;
        }
        JMenu menu5 = new JMenu("\u30d8\u30eb\u30d7(H)");
        menu5.setMnemonic('H');
        int i6 = 0;
        while (i6 < this.strMenuItemHelp.length) {
            this.itemHelp[i6] = new JMenuItem(this.strMenuItemHelp[i6]);
            this.itemHelp[i6].setMnemonic(this.charMenuItemHelp[i6]);
            menu5.add(this.itemHelp[i6]);
            this.itemHelp[i6].addActionListener(this);
            ++i6;
        }
        bar.add(menu0);
        bar.add(menu1);
        bar.add(menu2);
        bar.add(menu3);
        bar.add(menu4);
        bar.add(menu5);
        this.setJMenuBar(bar);
    }

    void makeTableScreen() {
        int height;
        int width;
        Container content = this.getContentPane();
        JScrollPane scrPane = new JScrollPane(this.table);
        content.add(scrPane);
        this.table.setRowHeight(120);
        DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.table.getColumnModel();
        TableColumn column = cmodel.getColumn(0);
        column.setCellEditor(new Cell0Editor(new JTextField()));
        column.setCellRenderer(new Cell0Renderer());
        column.setMaxWidth(50);
        column.setMinWidth(50);
        column.setPreferredWidth(50);
        column = cmodel.getColumn(1);
        column.setCellEditor(new Cell1Editor(new JTextField()));
        switch (this.model.getIconSize()) {
            case 2: {
                width = 640;
                height = 480;
                break;
            }
            case 1: {
                width = 320;
                height = 240;
                break;
            }
            default: {
                width = 160;
                height = 120;
            }
        }
        column.setMaxWidth(width);
        column.setMinWidth(width);
        column.setPreferredWidth(width);
        this.table.setRowHeight(height);
        column = cmodel.getColumn(2);
        Cell2Renderer rend = new Cell2Renderer();
        rend.setLineWrap(true);
        column.setCellEditor(new Cell2Editor(new JTextField()));
        column.setCellRenderer(rend);
        column = cmodel.getColumn(3);
        Cell2Renderer rend3 = new Cell2Renderer();
        rend3.setLineWrap(true);
        column.setCellEditor(new Cell2Editor(new JTextField()));
        column.setCellRenderer(rend3);
        column = cmodel.getColumn(4);
        column.setCellEditor(new Cell4Editor(new JTextField()));
        column.setCellRenderer(new Cell4Renderer());
        column.setMaxWidth(50);
        column.setMinWidth(50);
        column.setPreferredWidth(50);
        column = cmodel.getColumn(5);
        column.setCellRenderer(new Cell5Renderer());
        column.setMaxWidth(65);
        column.setMinWidth(65);
        column.setPreferredWidth(65);
        column = cmodel.getColumn(6);
        column.setMaxWidth(1);
        column.setMinWidth(1);
        column.setPreferredWidth(1);
        this.model.renumTotalTime();
        MyFocusListener myfocus = new MyFocusListener();
        this.table.addFocusListener(myfocus);
    }

    void enableEditLine(boolean sw) {
        JMenuBar b = this.getJMenuBar();
        JMenu m = b.getMenu(1);
        JMenuItem i = m.getItem(4);
        i.setEnabled(sw);
        i = m.getItem(5);
        i.setEnabled(sw);
    }

    public static void main(String[] args) {
        sbedit test = new sbedit();
        test.setDefaultCloseOperation(3);
        test.setBounds(test.window_px, test.window_py, test.window_sx, test.window_sy);
        test.setVisible(true);
    }

    sbedit() {
        URL url;
        Class<?> clazz;
        this.loadPreferences();
        this.myfilename = null;
        this.makeMenuBar();
        this.MenuFileNew();
        this.makeTableScreen();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("sbedit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getResource(".")) == null) {
            File jarfile = new File(String.valueOf(this.execpath) + File.separator + "sbedit.jar");
            while (!jarfile.exists()) {
                JOptionPane.showMessageDialog(this.getContentPane(), "\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u4e2d\nsbedit.jar\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044", "\u7d75\u30b3\u30f3\u30c6\u30a8\u30c7\u30a3\u30bf by \u306d\u3053\u3089", 1);
                JFileChooser chooser = new JFileChooser();
                SBDFileFilter filter = new SBDFileFilter();
                filter.addExtension("jar");
                filter.setDescription("Java Archive");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    this.execpath = chooser.getSelectedFile().getParent();
                    System.out.println("\u8d77\u52d5\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff1d" + this.execpath);
                }
                jarfile = new File(String.valueOf(this.execpath) + File.separator + "sbedit.jar");
                System.out.println("\u8d77\u52d5\u30c7\u30a3\u30ec\u30af\u30c8\u30ea+jar\uff1d" + jarfile.toString());
                Preferences prefs = Preferences.userRoot().node("nekora/sbedit");
                prefs.put("execpath", this.execpath);
            }
        } else {
            this.execpath = url.getPath();
        }
        FileSystemView v = FileSystemView.getFileSystemView();
        this.workroot = v.getDefaultDirectory() + File.separator + "sbeditwork";
        this.docwork = String.valueOf(this.workroot) + File.separator + this.model.getDocID();
        this.table.setUI(new MyTableUI());
        this.table.addMouseListener(new MoveControl());
    }

    void loadPreferences() {
        Preferences prefs = Preferences.userRoot().node("nekora/sbedit");
        this.window_px = new Integer(prefs.getInt("pointx", 10));
        this.window_py = new Integer(prefs.getInt("pointy", 10));
        this.window_sx = new Integer(prefs.getInt("sizex", 790));
        this.window_sy = new Integer(prefs.getInt("sizey", 470));
        this.execpath = prefs.get("execpath", null);
        Integer iconsize = new Integer(prefs.getInt("iconsize", 0));
        this.window_default_iconsize = iconsize;
    }

    void savePreferences() {
        Preferences prefs = Preferences.userRoot().node("nekora/sbedit");
        Rectangle re = this.getBounds();
        this.window_px = new Integer(re.x);
        this.window_py = new Integer(re.y);
        this.window_sx = new Integer(re.width);
        this.window_sy = new Integer(re.height);
        prefs.put("pointx", this.window_px.toString());
        prefs.put("pointy", this.window_py.toString());
        prefs.put("sizex", this.window_sx.toString());
        prefs.put("sizey", this.window_sy.toString());
        prefs.put("execpath", this.execpath);
        Integer iconsize = new Integer(this.window_default_iconsize);
        prefs.put("iconsize", iconsize.toString());
    }

    class SDBTable
    extends JTable {
        SDBTable(SBDTableModel m) {
            super(m);
        }
    }

    class Cell0Renderer
    extends DefaultTableCellRenderer {
        Cell0Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer Ir;
            if (value == null) {
                return this;
            }
            try {
                Ir = new Integer(sbedit.this.model.getValueAt(row, column).toString());
            }
            catch (Exception e) {
                Ir = new Integer(-1);
            }
            if (Ir > 0) {
                this.setValue("C" + Ir.toString());
            } else {
                this.setValue("");
            }
            this.setHorizontalAlignment(0);
            if (hasFocus) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(Color.lightGray);
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    class Cell2Renderer
    extends JTextArea
    implements TableCellRenderer {
        Cell2Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            this.setText((String)value);
            if (hasFocus) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    class Cell4Renderer
    extends DefaultTableCellRenderer {
        Cell4Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Double Ir;
            if (value == null) {
                return this;
            }
            try {
                Ir = new Double(sbedit.this.model.getValueAt(row, column).toString());
            }
            catch (Exception e) {
                Ir = new Double(-1.0);
            }
            if (Ir >= 0.0) {
                this.setHorizontalAlignment(4);
                float s = Ir.floatValue();
                int ss = Ir.intValue();
                if (s - (float)ss <= 0.0f) {
                    this.setValue(String.valueOf(ss) + "\u79d2");
                } else {
                    this.setValue(String.valueOf(Ir.toString()) + "\u79d2");
                }
            } else {
                this.setValue("");
            }
            if (hasFocus) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    class Cell5Renderer
    extends DefaultTableCellRenderer {
        Cell5Renderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Double Fr;
            if (value == null) {
                return this;
            }
            try {
                Fr = new Double(sbedit.this.model.getValueAt(row, column).toString());
            }
            catch (Exception e) {
                Fr = new Double(-1.0);
            }
            this.setHorizontalAlignment(4);
            if (Fr >= 60.0) {
                int ss;
                int m = Fr.intValue() / 60;
                double s = Fr - (double)(m * 60);
                if (s - (double)(ss = Fr.intValue() - m * 60) <= 0.0) {
                    this.setValue(String.valueOf(m) + "\u5206" + ss + "\u79d2");
                } else {
                    this.setValue(String.valueOf(m) + "\u5206" + s + "\u79d2");
                }
            } else if (Fr >= 0.0) {
                int ss;
                double s = Fr;
                if (s - (double)(ss = Fr.intValue()) <= 0.0) {
                    this.setValue(String.valueOf(ss) + "\u79d2");
                } else {
                    this.setValue(String.valueOf(s) + "\u79d2");
                }
            } else {
                this.setValue("");
            }
            if (hasFocus) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(Color.lightGray);
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    class Cell0Editor
    extends DefaultCellEditor {
        int editingRow;
        int editingColumn;
        int editingVal;

        Cell0Editor(JTextField tf) {
            super(tf);
            this.addCellEditorListener(new Editor0Listener());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Integer Ir;
            sbedit.this.enableEditLine(false);
            this.editingRow = row;
            this.editingColumn = column;
            try {
                Ir = new Integer(sbedit.this.model.getValueAt(row, column).toString());
            }
            catch (Exception e) {
                Ir = new Integer(-1);
            }
            this.editingVal = Ir;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        class Editor0Listener
        implements CellEditorListener {
            Editor0Listener() {
            }

            public void editingStopped(ChangeEvent e) {
                Integer Ir;
                try {
                    Ir = new Integer(((Cell0Editor)Cell0Editor.this).sbedit.this.model.getValueAt(Cell0Editor.this.editingRow, Cell0Editor.this.editingColumn).toString());
                }
                catch (Exception ex) {
                    Ir = new Integer(-1);
                }
                if (Cell0Editor.this.editingVal != Ir) {
                    ((Cell0Editor)Cell0Editor.this).sbedit.this.model.renumCutNumber(Cell0Editor.this.editingRow);
                }
                sbedit.this.enableEditLine(true);
            }

            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    class Cell1Editor
    extends DefaultCellEditor {
        int editingRow;
        JButton button;
        String fileName;

        Cell1Editor(JTextField tf) {
            super(tf);
            this.button = new JButton("\u30d5\u30a1\u30a4\u30eb\u9078\u629e");
            this.setClickCountToStart(2);
            this.addCellEditorListener(new CellButtonEnd());
            this.button.addActionListener(new ButtonCheck());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editingRow = row;
            this.fileName = value.toString();
            return this.button;
        }

        class ButtonCheck
        implements ActionListener {
            ButtonCheck() {
            }

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = Cell1Editor.this.fileName != null && Cell1Editor.this.fileName.length() > 0 ? new JFileChooser(Cell1Editor.this.fileName) : (((Cell1Editor)Cell1Editor.this).sbedit.this.lastloadimage != null && ((Cell1Editor)Cell1Editor.this).sbedit.this.lastloadimage.length() > 0 ? new JFileChooser(((Cell1Editor)Cell1Editor.this).sbedit.this.lastloadimage) : (((Cell1Editor)Cell1Editor.this).sbedit.this.myfilename != null && ((Cell1Editor)Cell1Editor.this).sbedit.this.myfilename.length() > 0 ? new JFileChooser(((Cell1Editor)Cell1Editor.this).sbedit.this.myfilename) : new JFileChooser()));
                SBDFileFilter filter = new SBDFileFilter();
                filter.addExtension("jpg");
                filter.addExtension("png");
                filter.addExtension("gif");
                filter.setDescription("Image");
                chooser.setFileFilter(filter);
                int stat = chooser.showOpenDialog(sbedit.this);
                if (stat == 1) {
                    return;
                }
                File file = chooser.getSelectedFile();
                ((Cell1Editor)Cell1Editor.this).sbedit.this.lastloadimage = Cell1Editor.this.fileName = file.getPath();
            }
        }

        class CellButtonEnd
        implements CellEditorListener {
            CellButtonEnd() {
            }

            public void editingStopped(ChangeEvent e) {
                ((Cell1Editor)Cell1Editor.this).sbedit.this.model.setValueAt(Cell1Editor.this.fileName, Cell1Editor.this.editingRow, 1);
                ((Cell1Editor)Cell1Editor.this).sbedit.this.editing = true;
            }

            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    class Cell2Editor
    extends DefaultCellEditor {
        JTextArea ta;
        JScrollPane scrPane;
        int editingRow;
        int editingColumn;

        Cell2Editor(JTextField tf) {
            super(tf);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new Editor2Listener());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            sbedit.this.enableEditLine(false);
            this.editingRow = row;
            this.editingColumn = column;
            this.ta = new JTextArea();
            this.scrPane = new JScrollPane(this.ta);
            this.ta.setText((String)value);
            return this.scrPane;
        }

        class Editor2Listener
        implements CellEditorListener {
            Editor2Listener() {
            }

            public void editingStopped(ChangeEvent e) {
                ((Cell2Editor)Cell2Editor.this).sbedit.this.model.setValueAt(Cell2Editor.this.ta.getText(), Cell2Editor.this.editingRow, Cell2Editor.this.editingColumn);
                sbedit.this.enableEditLine(true);
                ((Cell2Editor)Cell2Editor.this).sbedit.this.editing = true;
            }

            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    class Cell4Editor
    extends DefaultCellEditor {
        int editingRow;
        int editingColumn;
        double editingVal;

        Cell4Editor(JTextField tf) {
            super(tf);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new Editor4Listener());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Double Ir;
            sbedit.this.enableEditLine(false);
            this.editingRow = row;
            this.editingColumn = column;
            try {
                Ir = new Double(sbedit.this.model.getValueAt(row, column).toString());
            }
            catch (Exception e) {
                Ir = new Double(-1.0);
            }
            this.editingVal = Ir;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        class Editor4Listener
        implements CellEditorListener {
            Editor4Listener() {
            }

            public void editingStopped(ChangeEvent e) {
                Double Ir;
                try {
                    Ir = new Double(((Cell4Editor)Cell4Editor.this).sbedit.this.model.getValueAt(Cell4Editor.this.editingRow, Cell4Editor.this.editingColumn).toString());
                }
                catch (Exception ex) {
                    Ir = new Double(-1.0);
                }
                if (Cell4Editor.this.editingVal != Ir) {
                    ((Cell4Editor)Cell4Editor.this).sbedit.this.model.renumTotalTime();
                }
                sbedit.this.enableEditLine(true);
                ((Cell4Editor)Cell4Editor.this).sbedit.this.editing = true;
            }

            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        public void focusLost(FocusEvent ev) {
        }

        public void focusGained(FocusEvent e) {
        }
    }

    class MyTableUI
    extends BasicTableUI
    implements MouseMotionListener {
        MyTableUI() {
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            c.addMouseMotionListener(this);
        }

        public void mouseDragged(MouseEvent e) {
            e.consume();
        }

        public void mouseMoved(MouseEvent e) {
            e.consume();
        }
    }

    class MoveControl
    extends MouseAdapter {
        MoveControl() {
        }

        public void mousePressed(MouseEvent e) {
            if (sbedit.this.times == 0) {
                sbedit.this.table.setCursor(new Cursor(13));
                sbedit.this.oldPos = sbedit.this.table.getSelectedRow();
                if (sbedit.this.oldPos < 0) {
                    sbedit.this.oldPos = 0;
                }
                if (sbedit.this.oldPos > sbedit.this.model.getRowCount() - 1) {
                    sbedit.this.oldPos = sbedit.this.model.getRowCount() - 1;
                }
                sbedit.this.times = 1;
                sbedit.this.table.setRowSelectionAllowed(false);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (sbedit.this.times == 1) {
                sbedit.this.table.setCursor(new Cursor(0));
                int newPos = sbedit.this.table.rowAtPoint(e.getPoint());
                if (newPos < 0) {
                    newPos = 0;
                }
                if (newPos > sbedit.this.model.getRowCount() - 1) {
                    newPos = sbedit.this.model.getRowCount() - 1;
                }
                SBDTableModel model = (SBDTableModel)sbedit.this.table.getModel();
                System.out.println(String.valueOf(sbedit.this.oldPos) + " " + newPos);
                model.moveRow(sbedit.this.oldPos, sbedit.this.oldPos, newPos);
                sbedit.this.times = 0;
                sbedit.this.table.setRowSelectionAllowed(true);
                sbedit.this.table.setRowSelectionInterval(newPos, newPos);
                model.renumCutNumber(0);
                model.renumTotalTime();
            }
        }
    }
}

