#include <boost/random.hpp>

namespace ray
{
  namespace dice {

    int getRandom(int imin, int imax);
// =====================================================================

    class RangeRandom
      {
      public:
        typedef boost::mt19937 gen_type;
        typedef boost::uniform_smallint<> dst_type;
        typedef boost::variate_generator< gen_type, dst_type > rand_type;
        typedef gen_type::result_type gen_result_type;
        typedef unsigned long seed_type;
        typedef unsigned long count_type;

      private:
        bool m_overflow;
        count_type m_count;
        const seed_type m_seed;

        const gen_type m_gen;
        dst_type m_dst;
        rand_type m_rand;

      public:
        static const seed_type default_seed;
        static const gen_type default_mt_gen;

        RangeRandom(int _min, int _max);
//        RangeRandom(int _min, int _max, gen_type& _gen);
        RangeRandom(int _min, int _max, gen_result_type _seed);

        int next();

        bool isOverflow() const;
        count_type getCount() const;
        seed_type getSeed() const;
        dst_type::result_type getMin() const;
        dst_type::result_type getMax() const;

        RangeRandom& skipTo(unsigned long count);
        RangeRandom& skipBefore(unsigned long count);
      };

      int nDm(int num, int face);
  }
}
