
#include <lua5.1/lua.hpp>
#include "dice_parser.hpp"
#include "dice_funcs.h"
#include <iostream>
#include <vector>
#include <boost/bind.hpp>

lua_State * initLua() {
    lua_State *L;
    L = luaL_newstate(); //LuaĶ

    //LuaprintؿȤ褦ˤ
    lua_pushcfunction(L, luaopen_base);
    lua_call(L, 0, 0);

    return L;
}

void finalLua(lua_State *L) {
    lua_close(L);
}

typedef std::vector<int> param_t;

lua_Integer callLua(lua_State* L, const char * name, const param_t& params) {
//    std::cerr << "call function " << name << " with param ( ";
    //C++LuaδؿƤ 
    lua_getfield(L, LUA_GLOBALSINDEX, name); //å˴ؿѤ

    const param_t::const_iterator end = params.end();
    for( param_t::const_iterator it = params.begin(); it != end; ++it ) {
        lua_pushnumber(L, *it); //å˿ͤѤ
//        std::cerr << *it << " ";
    }
//    std::cerr << ")." << std::endl;

    lua_call(L, params.size(), 1); //ѤǡȤؿƤӽФ
    
    //ͤ
    lua_Integer result = lua_tointeger(L, -1);
    lua_pop(L, 1); //ͤ򥹥å

    return result;
}

int callnDm(lua_State* L) {
    lua_Integer n = lua_tointeger( L, 1 );
    lua_Integer f = lua_tointeger( L, 2 );
    int ret = ray::dice::nDm( n, f );
    lua_pushinteger( L, ret );
    return 1;
}

int main(int argc, char *argv[]) {
    if( argc < 2 ) {
        std::cout << "Usage : " << argv[0] << " filename" << std::endl;
        exit( 1 );
    }

    lua_State * L = initLua();

    //LuaեɾLuaĶLuaδؿϿ
    if( luaL_dofile(L, argv[1]) ) {
        std::cerr << "lua file (" << argv[1] << ") load error." << std::endl;
        std::cerr << "detail : " << lua_tostring(L, -1) << std::endl;
        finalLua(L);
        exit( 2 );
    }

    lua_register( L, "nDm", callnDm );

    ray::dice::DiceParser parser1;
    for(std::string str; getline(std::cin,str); )
    {
        // ϰԤʸˡ˽̵뤷ĤĲ
        const char* buf = str.c_str();
        ray::dice::parse_info_t r = parser1.ast_parse(buf, boost::spirit::space_p );
        if( r.full ) {
            ray::dice::calc_val_out( r.trees.begin(), boost::bind( callLua, L, _1, _2 ), std::cout );
            std::cout << " = " << str;
            std::cout << std::endl;
        }else {
            std::cout << "Parse fail on " << r.stop << std::endl;
        }
    }

    // λ
    finalLua(L);
    return 0;
}
