--[[
]]

module( "table", package.seeall )

function prefixes()
  return "TABLE"
end

dataTable = {}

function put(key, val, notice)
  dataTable[key] = val
  return notice .. "set Table[" .. key .. "] = " .. val
end

function get(key, notice)
  local val = dataTable[key]
  if val then
    return notice .. "Table[" .. key .. "] = " .. val
  end
  return notice .. "key '" .. key .. "' not found."
end

function on_msg(prefix, command, rest, notice)
  if string.match( prefix, "TABLE" ) then
    if string.match( command, "SET" ) then
      m, n = string.match( rest, " *([^ ]+) *(.+)" )
      if m and n then
        return put( m, n, notice )
      end
    elseif string.match( command, "GET" ) then
      m = string.match( rest, " *([^ ]+)" )
      print( m )
      if m then
        return get( m, notice )
      end
    else
      return notice .. "UNKNOWN command '" .. command .. "'."
    end
  elseif string.match( prefix, "SYS" ) then
    if string.match( command, "LIST" ) then
      return notice .. prefixes() .. " luaServer(table-server)"
    end
  end
  return ""
end
