/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#include <core/assert.h>
#include <core/cpu.h>
#include <core/initfunc.h>
#include <core/io.h>
#include <core/types.h>
#include <io/pci.h>
#include "io_io.h"

/* #define IOPASS_DEBUG */
#ifdef IOPASS_DEBUG
#include <core/printf.h>
#define IOPASS_DBG(...)						\
	do {							\
		printf(__VA_ARGS__);				\
	} while (0)
#else
#define IOPASS_DBG(...)
#endif

static int
restricted_io(iotype_t type, ioport_t port, void *data)
{
	ioport_t assigned_len;
#ifdef ENABLE_ASSERT
	bool write;
	ioport_t access_size;
#endif

	if (pci_assigned_ioport(port, &assigned_len)) {
#ifdef IOPASS_DEBUG
		if (port > 0x1000) {
			IOPASS_DBG("pass: type %d port 0x%x\n", type, port);
		}
#endif
		/*
		 * A I/O access is aligned to it's access size.
		 * A I/O resource is assngined on 4 byte granularity.
		 * So access_size should be equal to or less than assigned_len.
		 */
#ifdef ENABLE_ASSERT
		iotype_to_size_wr(type, &access_size, &write);
#endif
		ASSERT(access_size <= assigned_len);
		return 0; /* pass */
	}
#ifdef IOPASS_DEBUG
	if (port > 0x1000) {
		IOPASS_DBG("block: type %d port 0x%x\n", type, port);
	}
#endif
	return 1; /* no pass */
}

static void
io_iopass_init (void)
{
	u32 i;

	if (cpu_is_bsp()) {
		for (i = 0; i < NUM_OF_IOPORT; i++) {
			set_iofunc(i, do_io_pass);
		}
	} else {
		for (i = 0; i < NUM_OF_IOPORT; i++) {
			set_iofunc(i, restricted_io);
		}
	}
}

INITFUNC ("passvm0", io_iopass_init);
