/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#include <core/msg.h>
#include <core/printf.h>
#include <core/initfunc.h>
#include "asm.h"
#include "current.h"
#include "callrealmode.h"
#include "panic.h"
#include "reboot.h"
#include "sleep.h"
#include "smp.h"

static void
do_reboot (void)
{
	int i;
	u8 data;

	printf ("Rebooting...\n");

	for (i = 0; i < 0x10000; i++) {
		asm_inb(0x64, &data);
		if (!(data & 0x02)) {
			break;
		}
		usleep(2);
	}
	usleep(50);
	asm_outb(0x64, 0xfe);
	freeze();
}

static int
reboot_msghandler (int m, int c)
{
	if (m == 0) {
		/*
		 * To reboot machine, we seem to need to
		 * execute vmxoff.
		 */
		if (current && current->vmctl.vmexit) {
			current->vmctl.vmexit();
		}
		do_reboot ();
	}
	return 0;
}

static void
reboot_init_msg (void)
{
	msgregister ("reboot", reboot_msghandler);
}

void
reboot (void)
{
	do_reboot ();
}

INITFUNC ("msg0", reboot_init_msg);
