/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#ifndef __CORE_MM_H
#define __CORE_MM_H

#include <core/types.h>
#include <core/vmmerr.h>

#define MAPMEM_HPHYS			0x10000
#define MAPMEM_GPHYS			0x20000
#define MAPMEM_WRITE			0x40000
#define MAPMEM_CACHE_MASK		0x7
#define MAPMEM_WB			0x0 /* Write back (default) */
#define MAPMEM_UC			0x1
#define MAPMEM_WUC			0x2 /* Week UC */
#define MAPMEM_WC			0x3
#define MAPMEM_WT			0x4
#define MAPMEM_WP			0x5
#define MAPMEM_VALID_FLAG		0x00070007

#define MEM_TYPE_AVAILABLE		0x00000001
#define MEM_TYPE_RESERVED		0x00000002
#define MEM_TYPE_ACPI_RECLAIM		0x00000003
#define MEM_TYPE_ACPI_NVS		0x00000004

#define GMM_NO_MAPPING		0xFFFFFFFFFFFFFFFFLL

#define PAGE_SHIFT			12
#define PAGE_MASK			(((u64)-1) << PAGE_SHIFT)
#define PAGE_SIZE			(1 << PAGE_SHIFT)

vmmerr_t alloc_pages (void **virt, u64 *phys, int n);
vmmerr_t alloc_page (void **virt, u64 *phys);
void free_page (void *virt);
void free_page_phys (phys_t phys);
void *alloc (size_t len);
void free (void *virt);
virt_t phys_to_virt (phys_t phys);

/* accessing memory */
void unmapmem (void *virt, uint len);
void *mapmem (u32 flags, u64 physaddr, uint len);
void *mapmem_hphys (phys_t physaddr, uint len, u32 flags);
void *mapmem_gphys (phys_t physaddr, uint len, u32 flags);

/* accessing host physical memory */
void read_hphys_b (phys_t phys, void *data, u32 attr);
void write_hphys_b (phys_t phys, u32 data, u32 attr);
void read_hphys_w (phys_t phys, void *data, u32 attr);
void write_hphys_w (phys_t phys, u32 data, u32 attr);
void read_hphys_l (phys_t phys, void *data, u32 attr);
void write_hphys_l (phys_t phys, u32 data, u32 attr);
void read_hphys_q (phys_t phys, void *data, u32 attr);
void write_hphys_q (phys_t phys, u64 data, u32 attr);
bool cmpxchg_hphys_l (phys_t phys, u32 *olddata, u32 data, u32 attr);
bool cmpxchg_hphys_q (phys_t phys, u64 *olddata, u64 data, u32 attr);

/* accessing guest physical memory */
void read_gphys_b (phys_t phys, void *data, u32 flags);
void write_gphys_b (phys_t phys, u32 data, u32 flags);
void read_gphys_w (phys_t phys, void *data, u32 flags);
void write_gphys_w (phys_t phys, u32 data, u32 flags);
void read_gphys_l (phys_t phys, void *data, u32 flags);
void write_gphys_l (phys_t phys, u32 data, u32 flags);
void read_gphys_q (phys_t phys, void *data, u32 flags);
void write_gphys_q (phys_t phys, u64 data, u32 flags);
bool cmpxchg_gphys_l (phys_t phys, u32 *olddata, u32 data, u32 flags);
bool cmpxchg_gphys_q (phys_t phys, u64 *olddata, u64 data, u32 flags);

int get_phys_mem_map(int index, phys_t *base, phys_t *len, u32 *type);
int get_phys_mem_map_count(void);
struct resource *mm_next_mem_map(struct resource *resource);
u32 vmm_start_inf();
u32 vmm_term_inf();

#endif
