/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 */

#ifndef _CORE_VT_H
#define _CORE_VT_H

#include <common/list.h>
#include "asm.h"

enum intr_info_type {
	INTR_INFO_TYPE_EXTERNAL = 0,
	INTR_INFO_TYPE_NMI = 2,
	INTR_INFO_TYPE_HARD_EXCEPTION = 3,
	INTR_INFO_TYPE_SOFT_INTR = 4,
	INTR_INFO_TYPE_PRIV_SOFT_EXCEPTION = 5,
	INTR_INFO_TYPE_SOFT_EXCEPTION = 6,
};

enum intr_info_err {
	INTR_INFO_ERR_INVALID = 0,
	INTR_INFO_ERR_VALID = 1,
};

enum intr_info_valid {
	INTR_INFO_VALID_INVALID = 0,
	INTR_INFO_VALID_VALID = 1,
};

struct vt_io_data {
	bool iobmpflag;
	phys_t iobmpphys[2];
	void *iobmp[2];
};

struct vt_msr_entry {
	u32 index;
	u32 reserved;
	u64 data;
} __attribute__ ((packed));

struct vt_msr {
	struct vt_msr_entry *vmm;
	struct vt_msr_entry *guest;
	int count;
	int efer, star, lstar, cstar, fmask, kerngs;
};

struct vt_realmode_data {
	struct descreg idtr;
	ulong tr_limit, tr_acr, tr_base;
};

struct intr_info {
	unsigned int vector : 8;
	enum intr_info_type type : 3;
	enum intr_info_err err : 1;
	unsigned int nmi_unblocking : 1;
	unsigned int reserved : 18;
	enum intr_info_valid valid : 1;
} __attribute__ ((packed));

struct vt_intr_data {
	union {
		struct intr_info s;
		u32 v;
	} intr_info;
	u32 exception_errcode;
	u32 instruction_len;
};

struct vt_vmcs_info {
	void *vmcs_region_virt;
	phys_t vmcs_region_phys;
};

struct vt {
	struct vt_vmentry_regs vr;
	struct vt_vmcs_info vi;
	struct vt_realmode_data realmode;
	struct vt_intr_data intr;
	struct vt_io_data io;
	struct vt_msr msr;
	bool lme, lma;
	bool launched;
	bool ept_enabled;
	bool vpid_enabled;
};

struct vt_pcpu_data {
	u32 vmcs_revision_identifier;
	void *vmxon_region_virt;
	phys_t vmxon_region_phys;
	phys_t vmcs_region_phys;
};

struct vt_vm_data {
	spinlock_t	ept_lock;
	phys_t		ept_l4tbl;
	LIST2_DEFINE_HEAD(struct ept_tbl, ept_tbl_free_list);
	LIST2_DEFINE_HEAD(struct ept_tbl, ept_tbl_l1_list);
};

int vt_available (void);
void vt_vmctl_init (void);
void vt_init (void);

#endif
