/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2012-2014 Yuichi Watanabe
 */

#include <core/printf.h>
#include <core/initfunc.h>
#include "asm.h"
#include "constants.h"
#include "current.h"
#include "seg.h"
#include "vt_internal.h"

static void
vt_panic_dump2 (void)
{
}

#define DUMP_VMCS_FIELD(reg_name)			\
do {							\
	ulong reg_val;					\
	asm_vmread(reg_name, &reg_val);			\
	printf("    %s 0x%lx\n", #reg_name, reg_val);	\
} while(0)

static void
vt_dump_vmcs(void)
{
	printf("32-Bit Control Fields\n");
	DUMP_VMCS_FIELD(VMCS_PIN_BASED_VMEXEC_CTL);
	DUMP_VMCS_FIELD(VMCS_PROC_BASED_VMEXEC_CTL);
	DUMP_VMCS_FIELD(VMCS_EXCEPTION_BMP);
	DUMP_VMCS_FIELD(VMCS_PAGEFAULT_ERRCODE_MASK);
	DUMP_VMCS_FIELD(VMCS_PAGEFAULT_ERRCODE_MATCH);
	DUMP_VMCS_FIELD(VMCS_CR3_TARGET_COUNT);
	DUMP_VMCS_FIELD(VMCS_VMEXIT_CTL);
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSR_STORE_COUNT);
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSR_LOAD_COUNT);
	DUMP_VMCS_FIELD(VMCS_VMENTRY_CTL);
	DUMP_VMCS_FIELD(VMCS_VMENTRY_MSR_LOAD_COUNT);
	DUMP_VMCS_FIELD(VMCS_VMENTRY_INTR_INFO_FIELD);
	DUMP_VMCS_FIELD(VMCS_VMENTRY_EXCEPTION_ERRCODE);
	DUMP_VMCS_FIELD(VMCS_VMENTRY_INSTRUCTION_LEN);
	DUMP_VMCS_FIELD(VMCS_TPR_THRESHOLD);

	printf("64-Bit Control Fields\n");
	DUMP_VMCS_FIELD(VMCS_ADDR_IOBMP_A);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_ADDR_IOBMP_A_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_ADDR_IOBMP_B);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_ADDR_IOBMP_B_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_ADDR_MSRBMP);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_ADDR_MSRBMP_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSRSTORE_ADDR);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSRSTORE_ADDR_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSRLOAD_ADDR);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_VMEXIT_MSRLOAD_ADDR_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_VMENTRY_MSRLOAD_ADDR);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_VMENTRY_MSRLOAD_ADDR_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_EXEC_VMCS_POINTER);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_EXEC_VMCS_POINTER_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_TSC_OFFSET);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_TSC_OFFSET_HIGH);
#endif
	printf("Natural-Width Control Fields\n");
	DUMP_VMCS_FIELD(VMCS_CR0_GUESTHOST_MASK);
	DUMP_VMCS_FIELD(VMCS_CR4_GUESTHOST_MASK);
	DUMP_VMCS_FIELD(VMCS_CR0_READ_SHADOW);
	DUMP_VMCS_FIELD(VMCS_CR4_READ_SHADOW);
	DUMP_VMCS_FIELD(VMCS_CR3_TARGET_VALUE_0);
	DUMP_VMCS_FIELD(VMCS_CR3_TARGET_VALUE_1);
	DUMP_VMCS_FIELD(VMCS_CR3_TARGET_VALUE_2);
	DUMP_VMCS_FIELD(VMCS_CR3_TARGET_VALUE_3);

	printf("16-Bit Host-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_HOST_ES_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_CS_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_SS_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_DS_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_FS_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_GS_SEL);
	DUMP_VMCS_FIELD(VMCS_HOST_TR_SEL);

	printf("32-Bit Host-State Field\n");
	DUMP_VMCS_FIELD(VMCS_HOST_IA32_SYSENTER_CS);

	printf("Natural-Width Host-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_HOST_CR0);
	DUMP_VMCS_FIELD(VMCS_HOST_CR3);
	DUMP_VMCS_FIELD(VMCS_HOST_CR4);
	DUMP_VMCS_FIELD(VMCS_HOST_FS_BASE);
	DUMP_VMCS_FIELD(VMCS_HOST_GS_BASE);
	DUMP_VMCS_FIELD(VMCS_HOST_TR_BASE);
	DUMP_VMCS_FIELD(VMCS_HOST_GDTR_BASE);
	DUMP_VMCS_FIELD(VMCS_HOST_IDTR_BASE);
	DUMP_VMCS_FIELD(VMCS_HOST_IA32_SYSENTER_ESP);
	DUMP_VMCS_FIELD(VMCS_HOST_IA32_SYSENTER_EIP);
	DUMP_VMCS_FIELD(VMCS_HOST_RSP);
	DUMP_VMCS_FIELD(VMCS_HOST_RIP);

	printf("16-Bit Guest-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_GUEST_ES_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_CS_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_SS_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_DS_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_FS_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_GS_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_LDTR_SEL);
	DUMP_VMCS_FIELD(VMCS_GUEST_TR_SEL);

	printf("32-Bit Guest-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_GUEST_ES_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_CS_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_SS_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_DS_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_FS_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_GS_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_LDTR_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_TR_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_GDTR_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_IDTR_LIMIT);
	DUMP_VMCS_FIELD(VMCS_GUEST_ES_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_CS_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_SS_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_DS_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_FS_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_GS_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_LDTR_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_TR_ACCESS_RIGHTS);
	DUMP_VMCS_FIELD(VMCS_GUEST_INTERRUPTIBILITY_STATE);
	DUMP_VMCS_FIELD(VMCS_GUEST_ACTIVITY_STATE);
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_SYSENTER_CS);

	printf("64-Bit Guest-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_VMCS_LINK_POINTER);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_VMCS_LINK_POINTER_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_DEBUGCTL);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_DEBUGCTL_HIGH);
#endif
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_PAT);
#ifndef __x86_64__
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_PAT_HIGH);
#endif

	printf("Natural-Width Guest-State Fields\n");
	DUMP_VMCS_FIELD(VMCS_GUEST_CR0);
	DUMP_VMCS_FIELD(VMCS_GUEST_CR3);
	DUMP_VMCS_FIELD(VMCS_GUEST_CR4);
	DUMP_VMCS_FIELD(VMCS_GUEST_ES_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_CS_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_SS_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_DS_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_FS_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_GS_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_LDTR_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_TR_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_GDTR_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_IDTR_BASE);
	DUMP_VMCS_FIELD(VMCS_GUEST_DR7);
	DUMP_VMCS_FIELD(VMCS_GUEST_RSP);
	DUMP_VMCS_FIELD(VMCS_GUEST_RIP);
	DUMP_VMCS_FIELD(VMCS_GUEST_RFLAGS);
	DUMP_VMCS_FIELD(VMCS_GUEST_PENDING_DEBUG_EXCEPTIONS);
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_SYSENTER_ESP);
	DUMP_VMCS_FIELD(VMCS_GUEST_IA32_SYSENTER_EIP);
}

void
vt_panic_dump (void)
{
	ulong tmp, tmp2;
	ulong reason;

	current->vmctl.panic_dump = vt_panic_dump2;
	printf("Exit reason: ");
	asm_vmread(VMCS_EXIT_REASON, &reason);
	printexitreason(reason);
	asm_vmread (VMCS_EXIT_QUALIFICATION, &tmp);
	printf("Exit qualification %08lx ", tmp);
	asm_vmread(VMCS_VMEXIT_INTR_INFO, &tmp);
	printf("Exit intr info %08lx\n", tmp);
	asm_vmread(VMCS_VMEXIT_INTR_ERRCODE, &tmp);
	printf("Exit intr errcode %08lx ", tmp);
	asm_vmread(VMCS_GUEST_IDTR_BASE, &tmp);
	asm_vmread(VMCS_GUEST_IDTR_LIMIT, &tmp2);
	printf("VMCS IDTR %08lx+%08lx ", tmp, tmp2);
	asm_vmread(VMCS_GUEST_RFLAGS, &tmp);
	printf("VMCS RFLAGS %08lx\n", tmp);
	if (reason == EXIT_REASON_EPT_VIOLATION) {
		asm_vmread(VMCS_GUEST_PHYS_ADDR, &tmp);
		printf("Guest phys addr %08lx ", tmp);
		asm_vmread(VMCS_GUEST_LINEAR_ADDR, &tmp);
		printf("Guest linear addr %08lx\n", tmp);
	}
	if (reason == EXIT_REASON_EPT_MISCONFIG) {
		asm_vmread(VMCS_GUEST_PHYS_ADDR, &tmp);
		printf("Guest phys addr %08lx\n", tmp);
	}
	printf("pe=%d pg=%d ", current->u.vt.vr.pe, current->u.vt.vr.pg);
	printf("sw:en=0x%x ", current->u.vt.vr.sw.enable);
	printf("es=0x%x ", current->u.vt.vr.sw.es);
	printf("cs=0x%x ", current->u.vt.vr.sw.cs);
	printf("ss=0x%x ", current->u.vt.vr.sw.ss);
	printf("ds=0x%x ", current->u.vt.vr.sw.ds);
	printf("fs=0x%x ", current->u.vt.vr.sw.fs);
	printf("gs=0x%X\n", current->u.vt.vr.sw.gs);
	if (reason & EXIT_REASON_VMENTRY_FAILURE_BIT) {
		vt_vm_entry_check();
		vt_dump_vmcs();
	}
}
