#include <core/types.h>

#ifndef __CORE_BYTEORDER_H
#define	__CORE_BYTEORDER_H

/*
 * From FreeBSD sys/powerpc/include/endian.h
 */
/*-
 * Copyright (c) 1987, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)endian.h	8.1 (Berkeley) 6/10/93
 * $FreeBSD: release/9.2.0/sys/powerpc/include/endian.h 233349 2012-03-23 10:55:19Z dim $
 */

#if defined(__GNUCLIKE_BUILTIN_CONSTANT_P)
#define	__is_constant(x)	__builtin_constant_p(x)
#else
#define	__is_constant(x)	0
#endif

#define	__bswap16_const(x)	((((u16)(x) >> 8) & 0xff) |	\
	(((u16)(x) << 8) & 0xff00))
#define	__bswap32_const(x)	((((u32)(x) >> 24) & 0xff) |	\
	(((u32)(x) >> 8) & 0xff00) |				\
	(((u32)(x)<< 8) & 0xff0000) |				\
	(((u32)(x) << 24) & 0xff000000))
#define	__bswap64_const(x)	((((u64)(x) >> 56) & 0xff) |	\
	(((u64)(x) >> 40) & 0xff00) |				\
	(((u64)(x) >> 24) & 0xff0000) |				\
	(((u64)(x) >> 8) & 0xff000000) |				\
	(((u64)(x) << 8) & ((u64)0xff << 32)) |		\
	(((u64)(x) << 24) & ((u64)0xff << 40)) |		\
	(((u64)(x) << 40) & ((u64)0xff << 48)) |		\
	(((u64)(x) << 56) & ((u64)0xff << 56)))

static __inline u16
__bswap16_var(u16 _x)
{

	return ((_x >> 8) | ((_x << 8) & 0xff00));
}

static __inline u32
__bswap32_var(u32 _x)
{

	return ((_x >> 24) | ((_x >> 8) & 0xff00) | ((_x << 8) & 0xff0000) |
	    ((_x << 24) & 0xff000000));
}

static __inline u64
__bswap64_var(u64 _x)
{

	return ((_x >> 56) | ((_x >> 40) & 0xff00) | ((_x >> 24) & 0xff0000) |
	    ((_x >> 8) & 0xff000000) | ((_x << 8) & ((u64)0xff << 32)) |
	    ((_x << 24) & ((u64)0xff << 40)) |
	    ((_x << 40) & ((u64)0xff << 48)) | ((_x << 56)));
}

#define	__bswap16(x)	((u16)(__is_constant(x) ? __bswap16_const(x) : \
	__bswap16_var(x)))
#define	__bswap32(x)	(__is_constant(x) ? __bswap32_const(x) : \
	__bswap32_var(x))
#define	__bswap64(x)	(__is_constant(x) ? __bswap64_const(x) : \
	__bswap64_var(x))

/*
 * From FreeBSD usr/src/sys/endian.h
 */
/*-
 * Copyright (c) 2002 Thomas Moestl <tmm@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: release/9.2.0/sys/sys/endian.h 208331 2010-05-20 06:16:13Z phk $
 */

#define	bswap16(x)	__bswap16(x)
#define	bswap32(x)	__bswap32(x)
#define	bswap64(x)	__bswap64(x)

#define	htobe16(x)	bswap16((x))
#define	htobe32(x)	bswap32((x))
#define	htobe64(x)	bswap64((x))
#define	htole16(x)	((u16)(x))
#define	htole32(x)	((u32)(x))
#define	htole64(x)	((u64)(x))

#define	be16toh(x)	bswap16((x))
#define	be32toh(x)	bswap32((x))
#define	be64toh(x)	bswap64((x))
#define	le16toh(x)	((u16)(x))
#define	le32toh(x)	((u32)(x))
#define	le64toh(x)	((u64)(x))

/*
 * From FreeBSD usr/src/sys/ofed/include/asm/byteorder.h
 */
/*-
 * Copyright (c) 2010 Isilon Systems, Inc.
 * Copyright (c) 2010 iX Systems, Inc.
 * Copyright (c) 2010 Panasas, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define	cpu_to_le64	htole64
#define	le64_to_cpu	le64toh
#define	cpu_to_le32	htole32
#define	le32_to_cpu	le32toh
#define	cpu_to_le16	htole16
#define	le16_to_cpu	le16toh
#define	cpu_to_be64	htobe64
#define	be64_to_cpu	be64toh
#define	cpu_to_be32	htobe32
#define	be32_to_cpu	be32toh
#define	cpu_to_be16	htobe16
#define	be16_to_cpu	be16toh
#define	__be16_to_cpu	be16toh


#endif /* __CORE_BYTEORDER_H */
