/*
 * Copyright (c) 2013 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <core.h>
#include <core/types.h>
#include <core/panic.h>
#include <core/printf.h>
#include <core/rm.h>
#include <core/vm.h>
#include "vmrm.h"

struct vmrm {
	struct resource		mmio_resource;
	struct resource		io_resource;
};

static drvdata_hdl_t vmrm_handle;

static void
vmrm_vminit(void)
{
	struct vmrm *vmrm;

	vmrm = vm_get_driver_data(vmrm_handle);

	rm_init_resource(&vmrm->mmio_resource, 0, 0xffffffffffffffffLL,
			 RESOURCE_TYPE_MMIO, 0, "mmio_resource");
	rm_init_resource(&vmrm->io_resource, 0, 0x0000ffff,
			 RESOURCE_TYPE_IO, 0, "io_resource");
}

struct resource *
vmrm_mmio_resource(void)
{
	struct vmrm *vmrm;

	vmrm = vm_get_driver_data(vmrm_handle);

	return &vmrm->mmio_resource;
}

struct resource *
vmrm_io_resource(void)
{
	struct vmrm *vmrm;

	vmrm = vm_get_driver_data(vmrm_handle);

	return &vmrm->io_resource;
}

static void
vmrm_preinit(void)
{
	vmrm_handle = vm_alloc_driver_data(sizeof(struct vmrm));
}

FRMWK_VMINIT(vmrm_vminit);
DRIVER_PREINIT(vmrm_preinit);
