/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CORE_VM_CONFIG_H
#define __CORE_VM_CONFIG_H

#include <core/list.h>
#include <core/cpu.h>
#include <core/vm.h>

struct cpu_config {
	LIST2_DEFINE(struct cpu_config, cpu_list);
	apic_id_t apic_id;
};

struct mem_config {
	LIST2_DEFINE(struct mem_config, mem_list);
	phys_t start;
	phys_t end;
};

struct pci_config {
	LIST2_DEFINE(struct pci_config, pci_list);
	union {
		struct {
			unsigned int func_no:		3;
			unsigned int device_no:		5;
		} __attribute__ ((packed)) ;
		u8 devfn;
	};
	u8 bus_no;
};

struct vm_config {
	LIST2_DEFINE(struct vm_config, vm_config_list);
	char name[VM_NAME_BUF_SIZE];
	bool boot_int18;
	u8 boot_drive;
	bool boot_partition;
	LIST2_DEFINE_HEAD(cpu_list, struct cpu_config, cpu_list);
	LIST2_DEFINE_HEAD(mem_list, struct mem_config, cpu_list);
	LIST2_DEFINE_HEAD(pci_list, struct pci_config, pci_list);
};

struct vm_config_list {
	LIST2_DEFINE_HEAD(head, struct vm_config,
			  vm_config_list);
};

extern struct vm_config vm0_config;
extern struct vm_config_list vm_config_list;
extern apic_id_t shell_apic_id;

#endif /* __CORE_VM_CONFIG_H */
