/*
 * Copyright (c) 2012-2013 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CORE_ACPI_MADT_H
#define __CORE_ACPI_MADT_H

#include <core/types.h>
#define ACPI_MADT_SIGNATURE			"APIC"
#define APIC_STRUCT_TYPE_LOCAL_APIC		0
#define APIC_STRUCT_TYPE_IO_APIC		1
#define LOCAL_APIC_FLGAS_ENABLED		0x1
#define APIC_STRUCT_TYPE_LOCAL_X2APIC		9

struct acpi_madt {
	struct acpi_desc_header	header;
	u32			local_apic_addr;
	u32			flags;
} __attribute__ ((packed));

struct apic_header {
	u8			type;
	u8			length;
} __attribute__ ((packed));

struct local_apic {
	struct apic_header	header;
	u8			acpi_processor_id;
	u8			apic_id;
	u32			flags;
} __attribute__ ((packed));

struct madt_io_apic {
	struct apic_header	header;
	u8			io_apic_id;
	u8			reserved;
	u32			io_apic_address;
	u32			global_system_interrupt_base;
} __attribute__ ((packed));

struct local_x2apic {
	struct apic_header	header;
	u16			reserved;
	u32			x2apic_id;
	u32			flags;
	u32			acpi_processor_uid;
} __attribute__ ((packed));

#endif /* __CORE_ACPI_MADT_H */
