/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CORE_RM_H
#define __CORE_RM_H

#include <core/types.h>
#include <core/list.h>
#include <core/vmmerr.h>

#define RESOURCE_TYPE_INVALID	0x0
#define RESOURCE_TYPE_MEM	0x1
#define RESOURCE_TYPE_MMIO	0x2
#define RESOURCE_TYPE_IO	0x3

struct resource {
	LIST2_DEFINE_HEAD(children, struct resource, sibling);
	LIST2_DEFINE(struct resource, sibling);
	struct resource *parent;
	phys_t start;
	phys_t end;
	u32 type;
	u32 data;
	char *name;
};

#define RM_RESOURCE_NEXT(parent, resouece)\
	LIST2_NEXT((parent)->children, sibling, (resouece));

struct resource *rm_find_resource(struct resource *parent, phys_t addrress);
void rm_init_resource(struct resource *resource, phys_t start, phys_t end,
		      u32 type, u32 data, char *name);
vmmerr_t rm_insert_resource(struct resource *parent, struct resource *new);
vmmerr_t rm_alloc_avail_resource(struct resource *parent, struct resource *new,
				    phys_t start, phys_t end, phys_t align,
				    u32 type, u32 data, char *name);
vmmerr_t rm_alloc_resource(struct resource *parent, struct resource *new,
			   size_t size,  phys_t align, u32 type, u32 data,
			   char *name);
void rm_dump_resources(struct resource *resource);

#endif /* __CORE_RM_H */
