package tinytoolkits.weboard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

public class HTTPGate {

	URL _url;
	HttpURLConnection _urlconn;

	public HTTPGate(String path) throws MalformedURLException, IOException {
		//System.out.println("path=" + path);
		_url = new URL(path + "/cgi-bin/items.rb");
	}

	private void reset() throws IOException {
		//System.out.println("reset start");
		
		_urlconn = (HttpURLConnection) _url.openConnection();

		_urlconn.setRequestMethod("POST");
		_urlconn.setDoOutput(true);
		
		//System.out.println("reset ok");
	}

	public String getAll() throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=getAll");
		pw.close();

		return post();
	}

	public String addItem(Item item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=addItem");
		pw.print("&");
		pw.print("x=" + item.getX());
		pw.print("&");
		pw.print("y=" + item.getY());
		pw.print("&");
		pw.print("w=" + item.getW());
		pw.print("&");
		pw.print("h=" + item.getH());
		pw.print("&");
		pw.print("text=" + item.getText());

		pw.close();

		return post();
	}

	public String removeItem(Item item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=removeItem");
		pw.print("&");
		pw.print("itemID=" + item.getID());

		pw.close();

		return post();
	}

	public String changeItem(Item item) throws IOException {
		reset();

		PrintWriter pw = new PrintWriter(_urlconn.getOutputStream());
		pw.print("draw_command=changeItem");
		pw.print("&");
		pw.print("itemID=" + item.getID());
		pw.print("&");
		pw.print("x=" + item.getX());
		pw.print("&");
		pw.print("y=" + item.getY());
		pw.print("&");
		pw.print("w=" + item.getW());
		pw.print("&");
		pw.print("h=" + item.getH());
		pw.print("&");
		pw.print("text=" + item.getText());

		pw.close();

		return post();
	}

	public String post() throws IOException {
		_urlconn.connect();

		BufferedReader reader = new BufferedReader(new InputStreamReader(_urlconn.getInputStream(), Charset.forName("UTF-8")));

		StringBuffer sb = new StringBuffer();
		while (true) {
			String line = reader.readLine();
			if (line == null) {
				break;
			}
			sb.append(line + "\n");
		}

		reader.close();

		//_urlconn.disconnect();
		return sb.toString();
	}

	public void disconnect() {
		_urlconn.disconnect();
	}
}
