#include<iostream>
#include<GL/freeglut.h>
#include"./tlLeap.h"

#define ESCAPE 27
#define PI 3.141592653589793

using namespace std;

static int DisplayWidth = 512 , DisplayHeight = 512;
float distance , twist , elevation , azimuth;
double tipPosition[5][3];
static bool tapCheck = false;
static double addZ = 0.1;

void Re_display( void )
{
	glutPostRedisplay();
}

void idle( void ){
  if(tapCheck){
    addZ += 0.1;
    if(addZ > 20.0){
      tapCheck = false;
      addZ = 0.0;
    }
  }
  Re_display();
}

void MyLeapFunc( void ){
  if( tlLEAP(1,2) ){
    for(int i = 0; i < 5; i++){
      Vector tmp = tlGetData(1,i);//Vector
      tipPosition[i][0] = tmp[0];
      tipPosition[i][1] = tmp[1];
      tipPosition[i][2] = tmp[2];
    }
    addZ = 0.0;
    tapCheck = true;
  }
}

void display( void )
{
  double tipPositionNow[5][3];
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

        glColor3f( 0.0 , 0.0 , 0.0 );

  for(int i = 0; i < 5; i++){
    Vector tmp = tlGetData(1,i);//Vector
    tipPositionNow[i][0] = tmp[0];
    tipPositionNow[i][1] = tmp[1];
    tipPositionNow[i][2] = tmp[2];
  }
  for(int i = 0; i < 5; i++){
    glPushMatrix();
      glTranslated(tipPositionNow[i][0]/100.0,tipPositionNow[i][1]/100.0,tipPositionNow[i][2]/100.0);
      glutSolidSphere(0.3,10,10);
    glPopMatrix();
  }
  MyLeapFunc();
  if(tapCheck){
    for(int i = 0; i < 5; i++){
      glPushMatrix();
        glTranslated(tipPosition[i][0]/100.0,tipPosition[i][1]/100.0,tipPosition[i][2]/100.0 - addZ);
        glColor3f( 1.0 , 0.0 , 1.0 );
        glutSolidSphere(0.3,10,10);
      glPopMatrix();
    }
  }


	glutSwapBuffers();
	glFlush();
}

void keys( unsigned char key , int x , int y )
{
	if( key == ESCAPE ){ exit(0); }

	glutPostRedisplay();
}

void myinit()
{
	glClearColor( 1.0 , 1.0 , 1.0 , 1.0 );
	glEnable( GL_DEPTH_TEST );

	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
}

void changeParentWindow( GLsizei width , GLsizei height )
{
	if( height == 0 ){ height = 1; }
	glViewport( 0 , 0 , width , height );
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();

	gluPerspective( 45.0 , ( GLfloat )width / height , 0.01 , 500.0 );
	gluLookAt(6.0, 8.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
}

int main( int argc , char **argv )
{
	glutInit( &argc , argv );
	glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );
	glutInitWindowSize( DisplayWidth , DisplayHeight );
	glutCreateWindow("KeyTapDemo");
	glutReshapeFunc( changeParentWindow );
	glutDisplayFunc( display );
	glutIdleFunc( idle );
	glutKeyboardFunc( keys );

	myinit();
	glutMainLoop();
	return (0);
}
