#ifndef tlLeap
#define tlLeap
#include"Leap.h"

#define TL_PI 3.141592653589793

using namespace Leap;

typedef struct {
  Vector direction;
  Vector position;
  bool   extended;
}tlFinger;

typedef struct {
  tlFinger thumb;
  tlFinger index;
  tlFinger middle;
  tlFinger ring;
  tlFinger pinky;
}tlFingerList;

typedef struct {
  Vector direction;
  Vector position;
  tlFingerList fingerlist;
}tlHand;

Controller& tlController( void );
// call function
Vector tlGetData( int k        );
Vector tlGetData( int k, int j );
Vector tlGetData( Vector (*func)(const Controller& controller) );
int    tlLEAP(    int    (*func)(const Controller& controller) );
int    tlLEAP(    int    (*Func)(int i), int j              );
int    tlLEAP(    int    k,              int j              );
int    tlLEAP(    int    k,              int j, int *number );
int    tlcontinualGesture( int i );
int    tlsingleGesture(    int i );
int    tlHandState(        int i );
// set struct
tlFinger     tlSetFinger(     int  i );
tlFingerList tlSetFingerList( void   );
tlHand       tlSetHand(       void   );
// get data
Vector tlGetHandDirection(   const Controller& controller        );
Vector tlGetPalmPosition(    const Controller& controller        );
Vector tlGetFingerDirection( const Controller& controller, int i );
Vector tlGetTipPosition(     const Controller& controller, int i );
bool   tlFingerExtended(                                   int i );
// called function
int  SimplifyVector(                Vector      vec        );
void tlonGesturePattern(      const Controller& controller );
int  tlDetectGrab(            const Controller& controller );
int  tlDetectPinch(           const Controller& controller );
int  tlGetFingerState(        const Controller& controller );
int  tlDetectThumbsUP(        const Controller& controller );
int  tlGetHandMove(           const Controller& controller );
int  tlDiscriminationGesture( const Controller& controller );
int  tlCircle(                const Controller& controller );
int  tlSwipe(                 const Controller& controller );
int  tlKeyTap(                const Controller& controller );
int  tlScreenTap(             const Controller& controller );
int  tlsingleCircle(          const Controller& controller );
int  tlsingleSwipe(           const Controller& controller );
int  tlsingleKeyTap(          const Controller& controller );
int  tlsingleScreenTap(       const Controller& controller );

Controller& tlController( void ){
  static Controller controller;
  return controller;
}

Vector tlGetData( int k ){
  Vector (*func[2])(const Controller& controller) = {tlGetHandDirection,tlGetPalmPosition};
  Controller& controller = tlController();
  return func[k](controller);
}

Vector tlGetData( int k, int j ){
  Vector (*func[2])(const Controller& controller, int i) = {tlGetFingerDirection,tlGetTipPosition};
  Controller& controller = tlController();
  return func[k](controller,j);
}

Vector tlGetData( Vector (*func)(const Controller& controller) ){
  Controller& controller = tlController();
  return func(controller);
}

int tlLEAP( int (*func)(const Controller& controller) ){
  Controller& controller = tlController();
  if( controller.frame().hands().isEmpty() ){ return 0; }
  return func(controller);
}

int tlLEAP( int (*Func)(int i), int j ){
  return Func(j);
}

int tlLEAP( int k, int j ){
  int (*Func[3])(int i) = { tlcontinualGesture, tlsingleGesture, tlHandState };
  if( k < 0 || 2 < k ){ return 0; }
  return Func[k](j);
}

int tlLEAP( int k, int j, int *number ){
  int tmp = tlLEAP(k,j);
  if( tmp != 0 ){ *number = tmp; }
  return tmp;
}

int tlcontinualGesture( int i ){
  int (*func[4])(const Controller& controller) = { tlCircle, tlSwipe, tlKeyTap, tlScreenTap };
  Controller& controller = tlController();
  if( controller.frame().hands().isEmpty() ){ return 0; }
  if( i < 0 || 3 < i ){ return 0; }
  return func[i](controller);
}

int tlsingleGesture( int i ){
  int (*func[4])(const Controller& controller) = { tlsingleCircle, tlsingleSwipe, tlsingleKeyTap, tlsingleScreenTap };
  Controller& controller = tlController();
  if( controller.frame().hands().isEmpty() ){ return 0; }
  if( i < 0 || 3 < i ){ return 0; }
  return func[i](controller);
}

int tlHandState(int i){
  int (*func[4])(const Controller& controller) = { tlDetectGrab, tlDetectPinch, tlGetFingerState, tlDetectThumbsUP };
  Controller& controller = tlController();
  if( controller.frame().hands().isEmpty() ){ return 0; }
  if( i < 0 || 3 < i ){ return 0; }
  return func[i](controller);
}

tlFinger tlSetFinger(  int i ){
  tlFinger f;
  f.direction = tlGetData(0,i);
  f.position  = tlGetData(1,i);
  f.extended  = tlFingerExtended(i);
  return f;
}

tlFingerList tlSetFingerList( void ){
  tlFingerList fl;
  fl.thumb  = tlSetFinger(0);
  fl.index  = tlSetFinger(1);
  fl.middle = tlSetFinger(2);
  fl.ring   = tlSetFinger(3);
  fl.pinky  = tlSetFinger(4);
  return fl;
}

tlHand tlSetHand( void ){
  tlHand h;
  h.direction = tlGetData(0);
  h.position  = tlGetData(1);
  h.fingerlist = tlSetFingerList();
  return h;
}

Vector tlGetHandDirection( const Controller& controller ){
  return (controller.frame().hands()[0].direction());
}

Vector tlGetPalmPosition( const Controller& controller ){
  return (controller.frame().hands()[0].palmPosition());
}

Vector tlGetFingerDirection( const Controller& controller,int i ){
  return (controller.frame().hands()[0].fingers()[i].direction());
}

Vector tlGetTipPosition( const Controller& controller, int i ){
  return (controller.frame().hands()[0].fingers()[i].tipPosition());
}

bool tlFingerExtended( int i ){
  Controller& controller = tlController();
  return (controller.frame().hands()[0].fingers()[i].isExtended());
}

int SimplifyVector( Vector vec ){
  int a,b,c;
  float threshold = 0.4;
  if( vec[0] <= -threshold ){                       a =  1; }
  if( vec[0] >  -threshold && vec[0] < threshold ){ a =  2; }
  if( vec[0] >=  threshold ){                       a =  3; }
  if( vec[1] <= -threshold ){                       b = 18; }
  if( vec[1] >  -threshold && vec[1] < threshold ){ b =  9; }
  if( vec[1] >=  threshold ){                       b =  0; }
  if( vec[2] <= -threshold ){                       c =  0; }
  if( vec[2] >  -threshold && vec[2] < threshold ){ c =  3; }
  if( vec[2] >=  threshold ){                       c =  6; }

  return (a+b+c);
}

void tlonGesturePattern( const Controller& controller ){
  controller.enableGesture(Gesture::TYPE_SWIPE);
  controller.enableGesture(Gesture::TYPE_CIRCLE);
  controller.enableGesture(Gesture::TYPE_KEY_TAP);
  controller.enableGesture(Gesture::TYPE_SCREEN_TAP);
}

int tlDetectGrab( const Controller& controller){
  const Hand hand = controller.frame().hands()[0];
  if(      hand.grabStrength() > 0.8 ){ return 1; }
  else if( hand.grabStrength() < 0.2 ){ return 2; }
  else{ return 0; }
}

int tlDetectPinch( const Controller& controller){
  const Hand hand = controller.frame().hands()[0];
  if(      hand.pinchStrength() > 0.8 ){ return 1; }
  else if( hand.pinchStrength() < 0.2 ){ return 2; }
  else{ return 0; }
}

int tlGetPalmState( const Controller& controller ){
  const Hand hand = controller.frame().hands()[0];
  double palmthreshold = 0.4 ;
  int palmstate = 0;
  if(      hand.direction().pitch() >  palmthreshold ){ palmstate +=  1; }
  else if( hand.direction().pitch() < -palmthreshold ){ palmstate +=  2; }
  if(      hand.direction().yaw()   >  palmthreshold ){ palmstate +=  4; }
  else if( hand.direction().yaw()   < -palmthreshold ){ palmstate +=  8; }
  if(      hand.direction().roll()  >  palmthreshold ){ palmstate += 16; }
  else if( hand.direction().roll()  < -palmthreshold ){ palmstate += 32; }
  return palmstate;
}

int tlpow( int a, int x ){
  if( x == 0 ){ return 1; }
  int tmp = 1;
  for(int i = 0; i < x; ++i){
    tmp *= a;
  }
  return tmp;
}

int tlGetFingerState( const Controller& controller ){
  const FingerList fingers = controller.frame().hands()[0].fingers();
  int sum= 0;
  if( fingers.count() != 5 ){ return 0; }
  for(int i = 0; i < fingers.count(); ++i){
    if( fingers[i].isExtended() ){ sum += tlpow(2,i); }
  }
  return sum;
}

int tlDetectThumbsUP( const Controller& controller ){
  const FingerList fingers = controller.frame().hands()[0].fingers();
  if( SimplifyVector(fingers[0].direction()) != 2 || !fingers[0].isExtended() || fingers.count() != 5 ){ return 0; }
  for(int i = 1; i < fingers.count(); ++i){
    if( fingers[i].isExtended() ){ return 0; }
  }
  return 1;
}

int tlGetHandMove( const Controller& controller ){
  static bool base_check = false;
  static double Base_Position[3];
  Vector latest_position = controller.frame().hands()[0].palmPosition();
  if( tlLEAP(tlDetectGrab) == 1 ){
    Base_Position[0] = latest_position[0];
    Base_Position[1] = latest_position[1];
    Base_Position[2] = latest_position[2];
    base_check = true;
  }
  if( base_check ){
    if( Base_Position[0]+80.0 < latest_position[0] ){ return 1; }
    if( Base_Position[0]-80.0 > latest_position[0] ){ return 2; }
    if( Base_Position[2]-80.0 > latest_position[2] ){ return 3; }
    if( Base_Position[2]+80.0 < latest_position[2] ){ return 4; }
  }
  return 0;
}

int tlmaxCheck( int a[] ){
  int maxtmp = 0;
  for(int i = 1; i < 4; ++i){ if( a[maxtmp] < a[i] ){ maxtmp = i; } }
  if( a[maxtmp] == 0 ){ maxtmp = 4; }
  return maxtmp;
}

int tlDiscriminationGesture( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  int gestureCount[4] = {0,0,0,0};
  for(int g = 0; g < gestures.count(); ++g){
    switch( gestures[g].type() ){
      case Gesture::TYPE_CIRCLE:{
        ++gestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        ++gestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++gestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++gestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  return tlmaxCheck(gestureCount);
}

int tlCircle( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  int gestureCount[4] = {0,0,0,0};
  CircleGesture circle;
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        circle = gestures[g];
        ++gestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        ++gestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++gestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++gestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( tlmaxCheck(gestureCount) == 0 ){
    if( circle.pointable().direction().angleTo(circle.normal()) <= TL_PI/4 ){ return 1; }
    else{ return 2;}
  }
  return 0;
}

int tlSwipe( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  int gestureCount[4] = {0,0,0,0};
  Vector swipeDirection;
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        ++gestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        SwipeGesture swipe = gestures[g];
        swipeDirection = swipe.direction();
        ++gestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++gestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++gestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( tlmaxCheck(gestureCount) == 1 ){ return (SimplifyVector(swipeDirection)); }
  return 0;
}

int tlKeyTap( const Controller& controller ){
  if( tlDiscriminationGesture(controller) == 2 ){ return 1; }
  else{ return 0; }
}

int tlScreenTap( const Controller& controller ){
  if( tlDiscriminationGesture(controller) == 3 ){ return 1; }
  else{ return 0; }
}

int tlsingleCircle( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  static int GestureCount[4] = {0,0,0,0};
  static CircleGesture circle;
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        circle = gestures[g];
        ++GestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        ++GestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++GestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++GestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( gestures.isEmpty() ){
    if( tlmaxCheck(GestureCount) == 0 ){
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
      if( circle.pointable().direction().angleTo(circle.normal()) <= TL_PI/4 ){ return 1; }
      else{ return 2;}
    }else{
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
    }
  }
  return 0;
}

int tlsingleSwipe( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  static int GestureCount[4] = {0,0,0,0};
  static Vector swipeDirection;
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        ++GestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        SwipeGesture swipe = gestures[g];
        swipeDirection = swipe.direction();
        ++GestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++GestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++GestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( gestures.isEmpty() ){
    if( tlmaxCheck(GestureCount) == 1 ){ 
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
      return (SimplifyVector(swipeDirection));
    }else{
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
    }
  }
  return 0;
}

int tlsingleKeyTap( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  static int GestureCount[4] = {0,0,0,0};
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        ++GestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        ++GestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++GestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++GestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( gestures.isEmpty() ){
    if( tlmaxCheck(GestureCount) == 2 ){
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
      return 1;
    }else{
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
    }
  }
  return 0;
}

int tlsingleScreenTap( const Controller& controller ){
  tlonGesturePattern(controller);
  const GestureList gestures = controller.frame().gestures();
  static int GestureCount[4] = {0,0,0,0};
  for(int g = 0; g < gestures.count(); ++g){
    switch(gestures[g].type()){
      case Gesture::TYPE_CIRCLE:{
        ++GestureCount[0];
        break;
      }
      case Gesture::TYPE_SWIPE:{
        ++GestureCount[1];
        break;
      }
      case Gesture::TYPE_KEY_TAP:{
        ++GestureCount[2];
        break;
      }
      case Gesture::TYPE_SCREEN_TAP:{
        ++GestureCount[3];
        break;
      }
      default:
        break;
    }
  }
  if( gestures.isEmpty() ){
    if( tlmaxCheck(GestureCount) == 3 ){
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
      return 1;
    }else{
      GestureCount[0] = 0;
      GestureCount[1] = 0;
      GestureCount[2] = 0;
      GestureCount[3] = 0;
    }
  }
  return 0;
}

#endif // tlLeap
