/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARLIST_H__
#define __CHARLIST_H__


#include "tmaid.h"


/******************************************************************************
*                                                                             *
* ja:饯åȥꥹȥؿ                                 *
*                                                                             *
******************************************************************************/
/*  ja:饯åȤȽꤹ
    charset,饯å
        RET,TRUE:,FALSE:                                          */
gboolean
charlist_is_valid (const gchar *charset);


/*  ja:饯åȥꥹȤ
    charlist,饯åȥꥹ
         RET,줿饯åȥꥹ                             */
gchar *
charlist_strip (const gchar *charlist);


/*  ja:饯åȥꥹȤִ
    charlist0,饯åȥꥹ
    charlist1,ִ륭饯åȥꥹ
         RET,ִ줿饯åȥꥹ                             */
gchar *
charlist_rename (const gchar *charlist0,
                 const gchar *charlist1);


/*  ja:饯åȥꥹȤɲä
    charlist,饯åȥꥹ
    charsets,ɲä륭饯åȥꥹ
         RET,ɲä줿饯åȥꥹ                             */
gchar *
charlist_append (const gchar *charlist0,
                 const gchar *charlist1);


/*  ja:饯åȤ
    charlist,饯åȥꥹ
     charset,륭饯å
         RET,줿饯åȥꥹ                             */
gchar *
charlist_remove (const gchar *charlist,
                 const gchar *charset);


/*  ja:饯åȤִ
    charlist,ִ륭饯å
       ft_id,ե륿פID(-1:ɲäʤ)                                */
void
charlist_renewal_all (const gchar *charlist,
                      const gint ft_id);


/******************************************************************************
*                                                                             *
* ja:饯åȥꥹȥؿ                                 *
*                                                                             *
******************************************************************************/
/*  ja:饯åȥꥹȥɽ
    charlist,饯åȥꥹ                                       */
gchar *
charlist_dialog (gchar *charlist);


#endif
