/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "tmaid.h"


/******************************************************************************
*                                                                             *
* ja:ファイル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:ファイルの履歴に加える
    file,ファイル名                                                         */
void
file_set_history (const gchar *file);


/*  ja:ファイルを加える
    file,加えようとするファイルのフルパス
     RET,加えようとするファイルのラベル                                     */
gchar *
file_add_edit (const gchar *file,
               gint        *same);


/*  ja:ファイルを削除する
    file,削除しようとするファイルのフルパス                                 */
void
file_delete_edit (const gchar *file);


/*  ja:TXTファイルを開く
    tmaid,ウインドウ情報                                                 */
void
file_open_text (TmaidWindow *tmaid);


/*  ja:ファイルを開く
    file,ファイル名
     RET,ウインドウ情報                                                  */
TmaidWindow *
file_open_edit (const gchar *file);


/*  TXTファイルを保存する
     file,ファイル名
    tmaid,ウインドウ情報
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
file_save_text (const gchar *file,
                TmaidWindow *tmaid);


#endif
