/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __REPLACE_H__
#define __REPLACE_H__


#include "tmaid.h"


#define REPLACE_CANCEL -1
#define REPLACE_OK 1
#define REPLACE_ALL 2
#define REPLACE_NEXT 0


typedef struct ReplaceString_Tag
{
  gboolean arrow;
  gboolean ignorecase;
  gchar *src,*dst;
} ReplaceString;


extern gboolean replace_arrow;              /* ja:検索の設定 */
extern gboolean replace_ignorecase;         /* ja:置換の設定 */
extern gchar *replace_text[32];             /* ja:置換する文字列 */
extern gint replace_num;                    /* ja:登録されている置換文字列 */


/******************************************************************************
*                                                                             *
* ja:置換ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:置換ダイアログ表示
     rp,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
replace_dialog (ReplaceString *rp);


#endif
