/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __SIGFILE_H__
#define __SIGFILE_H__


#include "tmaid.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(タイマ)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_timeout (gpointer data);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(テキスト)                                        *
*                                                                             *
******************************************************************************/
gboolean
signal_focus_in (GtkWidget     *widget,
                 GdkEventFocus *event,
                 TmaidWindow   *tmaid);


gboolean
signal_focus_out (GtkWidget     *widget,
                  GdkEventFocus *event,
                  TmaidWindow   *tmaid);


void
signal_realize (GtkWidget   *widget,
                TmaidWindow *tmaid);


void
signal_unrealize (GtkWidget   *widget,
                  TmaidWindow *tmaid);


void
signal_value_changed_hscroll (GtkAdjustment *adjust,
                              TmaidWindow   *tmaid);


void
signal_value_changed_vscroll (GtkAdjustment *adjust,
                              TmaidWindow   *tmaid);


gboolean signal_config (GtkWidget         *widget,
                        GdkEventConfigure *config,
                        TmaidWindow       *tmaid);


void
signal_destroy_draw (GtkWidget   *widget,
                     TmaidWindow *tmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(Input Method)                                    *
*                                                                             *
******************************************************************************/
void
signal_commit (GtkIMContext *im_context,
               gchar        *arg1,
               TmaidWindow  *tmaid);
void
signal_preedit_changed (GtkIMContext *im_context,
                        TmaidWindow  *tmaid);


gboolean
signal_retrieve_surrounding (GtkIMContext *imcontext,
                             TmaidWindow  *tmaid);


gboolean
signal_delete_surrounding (GtkIMContext *imcontext,
                           gint          offset,
                           gint          n_chars,
                           TmaidWindow  *tmaid);


gboolean
signal_expose_preedit (GtkWidget      *widget,
                       GdkEventExpose *event,
                       TmaidWindow    *tmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(描画)                                            *
*                                                                             *
******************************************************************************/
gboolean
signal_expose (GtkWidget      *widget,
               GdkEventExpose *event,
               TmaidWindow    *tmaid);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(マウス)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_button_press (GtkWidget      *widget,
                     GdkEventButton *event,
                     TmaidWindow    *tmaid);


gboolean
signal_motion_notify (GtkWidget      *widget,
                      GdkEventMotion *event,
                      TmaidWindow    *tmaid);


gboolean
signal_button_release (GtkWidget      *widget,
                       GdkEventButton *event,
                       TmaidWindow    *tmaid);


gboolean
signal_scroll (GtkWidget      *widget,
               GdkEventScroll *event,
               TmaidWindow    *tmaid);


#endif
