/*
    charset
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_CHARSET_H__
#define __MISC_CHARSET_H__


#include "common.h"
#include "charuty.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_CHARSET            (misc_charset_get_type ())
#define MISC_CHARSET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_CHARSET, MiscCharset))
#define MISC_CHARSET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_CHARSET, MiscCharsetClass))
#define MISC_IS_CHARSET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_CHARSET))
#define MISC_IS_CHARSET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_CHARSET))
#define MISC_CHARSET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_CHARSET, MiscCharsetClass))


typedef struct _MiscCharset      MiscCharset;
typedef struct _MiscCharsetClass MiscCharsetClass;

struct _MiscCharset
{
  /*< private >*/
  GtkWindow parent_instance;

  /*< public >*/

  /*< private >*/
};

struct _MiscCharsetClass
{
  GtkComboClass parent_class;

  /* -- signals -- */
  void (*activate) (MiscCharset *charlist);
  void (*changed) (MiscCharset *charlist);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_charset_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
misc_charset_new (void);


/*  ja:文字符号化方式を取得する
    charset,ウィジェット
        RET,文字符号化方式                                                  */
#define misc_charset_get_charset(charset)                                   \
((charset)?g_strdup (gtk_entry_get_text                                     \
                                (GTK_ENTRY(GTK_COMBO(charset)->entry))):NULL)


/*  ja:文字符号化方式を設定する
    charset,ウィジェット
        str,文字符号化方式
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
misc_charset_set_charset (MiscCharset *charset,
                          const gchar *str);


/*  ja:文字符号化方式の候補を取得する
    charset,ウィジェット
        RET,文字符号化方式の候補                                            */
gchar *
misc_charset_get_candidate (MiscCharset *charset);


/*  ja:文字符号化方式の候補を追加する
      charset,ウィジェット
    candidate,文字符号化方式の候補
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
misc_charset_add_candidate (MiscCharset *charset,
                            const gchar *candidate);


/*  ja:文字符号化方式の候補を削除する
      charset,ウィジェット
    candidate,文字符号化方式の候補,NULL:すべて削除
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
misc_charset_remove_candidate (MiscCharset *charset,
                               const gchar *candidate);


/*  ja:文字符号化方式が正しいか判定する
    charset,ウィジェット
        RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式            */
#define misc_charset_is_valid(charset)                                      \
((charset)?charuty_is_valid(gtk_entry_get_text                              \
                                (GTK_ENTRY(GTK_COMBO(charset)->entry))):FALSE)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_CHARSET_H__ */
