/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "misc/misc_charset.h"
#include "reload.h"


/******************************************************************************
*                                                                             *
* ja:リロードダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
static gboolean reload_clicked_ok;
static GtkWidget *dialog, *button0, *check0, *check1, *combo, *charset;


/* ja:OKボタンの表示/非表示を判定 */
static void
reload_dialog_ok_sensitive (GtkWidget *widget,
                            gpointer   user_data)
{
  gtk_widget_set_sensitive (button0,
                            misc_charset_is_valid (MISC_CHARSET (charset)));
}


/* ja:OKボタンが押された */
static void
reload_dialog_clicked (GtkWidget *widget,
                       FileType  *ft)
{
  const gchar *str;
  GList *glist;

  g_free (ft->charset);
  ft->html = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check0));
  ft->esc = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check1));
  str = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  glist = gtk_container_children (GTK_CONTAINER (GTK_COMBO (combo)->list));
  for (ft->crlf = g_list_length (glist) - 1; ft->crlf >= 0; ft->crlf--)
    if (!g_strcmp (gtk_label_get_text (GTK_LABEL (gtk_bin_get_child
                        (GTK_BIN (g_list_nth_data (glist, ft->crlf))))), str))
      break;
  g_list_free (glist);
  if (ft->crlf < 0)
    ft->crlf = 0;
  ft->charset = misc_charset_get_charset (MISC_CHARSET (charset));
  gtk_widget_destroy (dialog);
  reload_clicked_ok = TRUE;
}


/* ja:コンボボックスでリターンが押された */
static void
reload_dialog_activate (GtkWidget *widget,
                        FileType  *ft)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    reload_dialog_clicked (widget, ft);
}


/* ja:ESCが押された */
static gboolean
reload_dialog_key_press (GtkWidget   *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:リロードダイアログ表示
      ft,ファイルタイプ
    text,説明文
     RET,TRUE:OK,FALSE:Cancel                                               */
gboolean
reload_dialog (FileType    *ft,
               const gchar *text)
{
  gint i;
  GList *glist;
  GtkWidget *button1, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Reload"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (reload_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  if (text)
    {
      button0 = gtk_button_new_with_mnemonic (_("_Yes"));
      button1 = gtk_button_new_with_mnemonic (_("_No"));
    }
  else
    {
      button0 = gtk_button_new_with_label (_("OK"));
      button1 = gtk_button_new_with_label (_("Cancel"));
    }
  g_signal_connect (G_OBJECT (button0), "clicked",
                                    G_CALLBACK (reload_dialog_clicked), ft);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:チェックボタン */
  check0 = gtk_check_button_new_with_mnemonic
                                    (_("_HTML Numeric character reference"));
  check1 = gtk_check_button_new_with_mnemonic (_("_Escape sequence"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check0), ft->html);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check1), ft->esc);
  g_signal_connect (G_OBJECT (check0), "toggled",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  g_signal_connect (G_OBJECT (check1), "toggled",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  /* ja:コンボボックス */
  glist = g_list_append (NULL, "CR+LF");
  glist = g_list_append (glist, "CR");
  glist = g_list_append (glist, "LF");
  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry),
                                            g_list_nth_data (glist, ft->crlf));
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo)->entry), FALSE);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "activate",
                                    G_CALLBACK (reload_dialog_activate), ft);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  /* ja:文字符号化方式 */
  charset = misc_charset_new ();
  for (i = 0; i < ftnum; i++)
    misc_charset_add_candidate (MISC_CHARSET (charset), ftype[i].charset);
  misc_charset_set_charset (MISC_CHARSET (charset), ft->charset);
  g_signal_connect (G_OBJECT (charset), "activate",
                                    G_CALLBACK (reload_dialog_activate), ft);
  g_signal_connect (G_OBJECT (charset), "changed",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  /* ja:フレームとボックス */
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  if (text)
    gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (text), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), combo, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), charset, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (text ? button1 : button0);

  reload_clicked_ok = FALSE;

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return reload_clicked_ok;
}
