/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "find.h"
#include "replace.h"


gboolean replace_arrow = TRUE;              /* ja:置換の設定 */
gboolean replace_ignorecase = FALSE;        /* ja:置換の設定 */
gchar *replace_text[32];                    /* ja:置換する文字列 */
gint replace_num = 0;                       /* ja:登録されている置換文字列 */


/******************************************************************************
*                                                                             *
* ja:置換ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
static gint replace_clicked_button;
static GtkWidget *dialog;
static GtkWidget *button0, *button1, *check, *combo0, *combo1, *radio1;


/* ja:置換ボタンが押された */
static void
replace_dialog_clicked_ok (GtkWidget     *widget,
                           ReplaceString *rp)
{
#if GTK_CHECK_VERSION(2,4,0)
  rp->src = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo0)->child)));
  rp->dst = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo1)->child)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  rp->src = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo0)->entry)));
  rp->dst = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo1)->entry)));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  rp->ignorecase = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check));
  rp->arrow = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio1));
  gtk_widget_destroy (dialog);
  replace_clicked_button = REPLACE_OK;
}


/* ja:すべて置換ボタンが押された */
static void
replace_dialog_clicked_all (GtkWidget     *widget,
                            ReplaceString *rp)
{
#if GTK_CHECK_VERSION(2,4,0)
  rp->src = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo0)->child)));
  rp->dst = g_strdup (gtk_entry_get_text
                                        (GTK_ENTRY (GTK_BIN (combo1)->child)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  rp->src = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo0)->entry)));
  rp->dst = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo1)->entry)));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  rp->ignorecase = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check));
  rp->arrow = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio1));
  gtk_widget_destroy (dialog);
  replace_clicked_button = REPLACE_ALL;
}


/* ja:エントリーでリターンが押された */
static void
replace_dialog_activate (GtkWidget     *widget,
                         ReplaceString *rp)
{
#if GTK_CHECK_VERSION(2,4,0)
  if (g_strlen (gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo0)->child))) > 0)
#else /* not GTK_CHECK_VERSION(2,4,0) */
  if (g_strlen (gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo0)->entry))) > 0)
#endif /* not GTK_CHECK_VERSION(2,4,0) */
    replace_dialog_clicked_ok(widget,rp);
}


/* ja:エントリーが変更された */
static void
replace_dialog_changed (GtkWidget *widget,
                        gpointer   user_data)
{
  gboolean sensitive;

  sensitive = g_strlen (gtk_entry_get_text (GTK_ENTRY (widget))) > 0;
  gtk_widget_set_sensitive (button0, sensitive);
  gtk_widget_set_sensitive (button1, sensitive);
}


/* ja:ESCが押された */
static gboolean
replace_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:置換ダイアログ表示
     rp,置換情報
    RET,REPLACE_OK,REPLACE_NEXT,REPLACE_ALL,REPLACE_CANCEL                  */
gint
replace_dialog (ReplaceString *rp)
{
  gboolean sensitive;
  gint i;
#if ! GTK_CHECK_VERSION(2,4,0)
  GList *glist = NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  GtkWidget *radio0, *button2;
  GtkWidget *frame0, *frame1, *hbox, *tbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Replace"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (replace_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_mnemonic (_("_Replace"));
  button1 = gtk_button_new_with_mnemonic (_("_All Replace"));
  button2 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                                G_CALLBACK (replace_dialog_clicked_ok), rp);
  g_signal_connect (G_OBJECT (button1), "clicked",
                                G_CALLBACK (replace_dialog_clicked_all), rp);
  g_signal_connect_swapped (G_OBJECT (button2), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("Enable _Case"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), rp->ignorecase);
  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
  combo0 = gtk_combo_box_entry_new_text ();
  combo1 = gtk_combo_box_entry_new_text ();
  for (i = 0; i < find_num; i++)
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo0), find_text[i]);
  for (i = 0; i < replace_num; i++)
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo1), replace_text[i]);
  if (find_num > 0)
    {
      gtk_combo_box_set_active (GTK_COMBO_BOX (combo0), 0);
      gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (combo0)->child),
                                                                        0, -1);
    }
  if (replace_num > 0)
    {
      gtk_combo_box_set_active (GTK_COMBO_BOX (combo1), 0);
      gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (combo1)->child),
                                                                        0, -1);
    }
  g_signal_connect (G_OBJECT (GTK_BIN (combo0)->child), "activate",
                                    G_CALLBACK (replace_dialog_activate), rp);
  g_signal_connect (G_OBJECT (GTK_BIN (combo1)->child), "activate",
                                    G_CALLBACK (replace_dialog_activate), rp);
  g_signal_connect (G_OBJECT (GTK_BIN (combo0)->child), "changed",
                                    G_CALLBACK (replace_dialog_changed), NULL);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  for (i = 0; i < find_num; i++)
    glist = g_list_append (glist, find_text[i]);
  combo0 = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (combo0), FALSE, TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo0), TRUE);
  if (find_num > 0)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (combo0), glist);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo0)->entry), find_text[0]);
      gtk_editable_select_region (GTK_EDITABLE (GTK_COMBO (combo0)->entry),
                                                                        0,-1);
      g_list_free (glist);
    }
  g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "activate",
                                    G_CALLBACK (replace_dialog_activate), rp);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "changed",
                                    G_CALLBACK (replace_dialog_changed), NULL);
  glist = NULL;
  for (i = 0; i < replace_num; i++)
    glist = g_list_append (glist, replace_text[i]);
  combo1 = gtk_combo_new ();
  gtk_combo_set_value_in_list (GTK_COMBO (combo1), FALSE, TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo1), TRUE);
  if (replace_num > 0)
    {
      gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo1)->entry),
                                                            replace_text[0]);
      g_list_free (glist);
    }
  g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "activate",
                                    G_CALLBACK (replace_dialog_activate), rp);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  /* ja:ラジオボタン */
  radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Up"));
  radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Down"));
  gtk_toggle_button_set_active
                    (GTK_TOGGLE_BUTTON (rp->arrow ? radio1 : radio0), TRUE);
  /* ja:フレームとボックス */
  tbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (tbox), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Find String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), combo0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox),
                        gtk_label_new (_("Replace String")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), combo1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);

  frame0 = gtk_frame_new (_("Option"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), vbox);

  frame1 = gtk_frame_new (_("Direction"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), radio0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio1, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (tbox), hbox, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button2, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (tbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), tbox);

  /* ja:表示 */
#if GTK_CHECK_VERSION(2,4,0)
  sensitive = g_strlen (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_BIN (combo0)->child))) > 0;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  sensitive = g_strlen (gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo0)->entry))) > 0;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_set_sensitive (button0, sensitive);
  gtk_widget_set_sensitive (button1, sensitive);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_widget_grab_focus (GTK_BIN (combo0)->child);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_grab_focus (GTK_COMBO (combo0)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  replace_clicked_button = REPLACE_CANCEL;

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return replace_clicked_button;
}
