/*
    orzmdi
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ORZ_MDI_H__
#define __ORZ_MDI_H__


#include "gcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_MDI            (orz_mdi_get_type ())
#define ORZ_MDI(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_MDI, OrzMdi))
#define ORZ_MDI_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_MDI, OrzMdiClass))
#define ORZ_IS_MDI(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_MDI))
#define ORZ_IS_MDI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_MDI))
#define ORZ_MDI_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_MDI, OrzMdiClass))


typedef struct _OrzMdi      OrzMdi;
typedef struct _OrzMdiClass OrzMdiClass;
typedef struct _OrzMdiTab   OrzMdiTab;

struct _OrzMdi
{
  /*< private >*/
  GtkNotebook parent_instance;

  /*< public >*/

  /*< private >*/
  GtkTooltips *tooltips;
};

struct _OrzMdiClass
{
  GtkNotebookClass parent_class;

  /* -- signals -- */
  void (*add_window) (OrzMdi   *mdi,
                      guint     page_num,
                      gpointer *page_data);
  void (*change_window) (OrzMdi   *mdi,
                         guint     page_num,
                         gpointer *page_data);
  void (*close_window) (OrzMdi   *mdi,
                        guint     page_num,
                        gpointer *page_data);
  void (*remove_window) (OrzMdi   *mdi,
                         guint     page_num,
                         gpointer *page_data);
  void (*reorder_window) (OrzMdi   *mdi,
                          guint     page_num,
                          gpointer *page_data);
  void (*switch_window) (OrzMdi   *mdi,
                         guint     page_num,
                         gpointer *page_data);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_mdi_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_mdi_new (void);


/*  ja:ページを最後に追加する
          mdi,ウィジェット
        child,内容
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
gint
orz_mdi_append_page (OrzMdi         *mdi,
                     GtkWidget      *child,
                     const gchar    *file,
                     const gboolean  created,
                     gpointer        page_data);


/*  ja:ページを最後に追加する
          mdi,ウィジェット
        child,内容
         menu,メニュー
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
gint
orz_mdi_append_page_menu (OrzMdi         *mdi,
                          GtkWidget      *child,
                          GtkWidget      *menu,
                          const gchar    *file,
                          const gboolean  created,
                          gpointer        page_data);


/*  ja:ページを最初に追加する
          mdi,ウィジェット
        child,内容
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
gint
orz_mdi_prepend_page (OrzMdi         *mdi,
                      GtkWidget      *child,
                      const gchar    *file,
                      const gboolean  created,
                      gpointer        page_data);


/*  ja:ページを最初に追加する
          mdi,ウィジェット
        child,内容
         menu,メニュー
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
gint
orz_mdi_prepend_page_menu (OrzMdi         *mdi,
                           GtkWidget      *child,
                           GtkWidget      *menu,
                           const gchar    *file,
                           const gboolean  created,
                           gpointer        page_data);


/*  ja:ページを挿入する
          mdi,ウィジェット
        child,内容
     position,位置(0...)
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
       RET,ページ(0...,-1:エラー)                                           */
gint
orz_mdi_insert_page (OrzMdi         *mdi,
                     GtkWidget      *child,
                     const gint      position,
                     const gchar    *file,
                     const gboolean  created,
                     gpointer        page_data);


/*  ja:ページを挿入する
          mdi,ウィジェット
        child,内容
         menu,メニュー
     position,位置(0...)
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
       RET,ページ(0...,-1:エラー)                                           */
gint
orz_mdi_insert_page_menu (OrzMdi         *mdi,
                          GtkWidget      *child,
                          GtkWidget      *menu,
                          const gint      position,
                          const gchar    *file,
                          const gboolean  created,
                          gpointer        page_data);


/*  ja:ページ数を取得する
    mdi,ウィジェット
    RET,ページ数                                                            */
gint
orz_mdi_get_n_pages (OrzMdi *mdi);


/*  ja:ページをデータから取得する
          mdi,ウィジェット
    page_data,ページデータ
          RET,ページ(0...),-1:なし                                          */
gint
orz_mdi_get_page_from_data (OrzMdi   *mdi,
                            gpointer  page_data);


/*  ja:ページデータを取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,ページデータ                                                   */
gpointer
orz_mdi_get_data (OrzMdi     *mdi,
                  const gint  page_num);


/*  ja:ページデータを設定する
           mdi,ウィジェット
      page_num,ページ(0...),-1:カレント
     page_data,ページデータ
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
orz_mdi_set_data (OrzMdi     *mdi,
                  const gint  page_num,
                  gpointer    page_data);


/*  ja:ページのファイル名を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,ファイル名,NULL:エラー                                         */
const gchar *
orz_mdi_get_file (OrzMdi     *mdi,
                  const gint  page_num);


/*  ja:ページのファイル名を設定する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
        file,ファイル名
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
orz_mdi_set_file (OrzMdi      *mdi,
                  const gint   page_num,
                  const gchar *file);


/*  ja:ページの作成状態を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,TRUE:新規作成,FALSE:既存ファイル                               */
gboolean
orz_mdi_get_created (OrzMdi     *mdi,
                     const gint  page_num);


/*  ja:ページの作成状態を設定する
          mdi,ウィジェット
     page_num,ページ(0...),-1:カレント
    is_create,TRUE:新規作成,FALSE:既存ファイル
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_mdi_set_created (OrzMdi         *mdi,
                     const gint      page_num,
                     const gboolean  is_create);


/*  ja:ページの編集状態を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,TRUE:編集済み,FALSE:未編集                                     */
gboolean
orz_mdi_get_edited (OrzMdi     *mdi,
                    const gint  page_num);


/*  ja:ページの編集状態を設定する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
     is_edit,TRUE:編集済み,FALSE:未編集
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
orz_mdi_set_edited (OrzMdi         *mdi,
                    const gint      page_num,
                    const gboolean  is_edit);


/*  ja:ページを移動する
             mdi,ウィジェット
    page_num_src,ページ(0...),-1:カレント
    page_num_dst,ページ(0...),-1:末尾
             RET,TRUE:正常終了,FALSE:エラー                                 */
gboolean
orz_mdi_reorder (OrzMdi     *mdi,
                 const gint  page_num_src,
                 const gint  page_num_dst);


/*  ja:ページの表示名を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,表示名                                                         */
const gchar *
orz_mdi_get_display_name (OrzMdi     *mdi,
                          const gint  page_num);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_MDI_H__ */
