/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FIND_H__
#define __FIND_H__


#include "tmaid.h"


G_BEGIN_DECLS


typedef struct _FindString
{
  gboolean arrow;
  gboolean ignorecase;
  gchar *text;
} FindString;


extern gboolean find_arrow;                 /* ja:検索の設定 */
extern gboolean find_ignorecase;            /* ja:検索の設定 */
extern gchar *find_text[32];                /* ja:検索する文字列 */
extern gint find_num;                       /* ja:登録されている検索文字列 */


/******************************************************************************
*                                                                             *
* ja:検索関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:検索
         tmaid,ウインドウ情報
         start,検索範囲
           end,検索範囲(x=-1ならば選択範囲なし)
          find,検索文字列
         arrow,TRUE:下へ,FALSE:上へ
    ignorecase,TRUE:大文字小文字を区別する,FALSE:大文字小文字を区別しない   */
void
find_operation (TmaidWindow    *tmaid,
                GdkPoint       *start,
                GdkPoint       *end,
                const gchar    *find,
                const gboolean  arrow,
                const gboolean  ignorecase);


/******************************************************************************
*                                                                             *
* ja:検索ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:検索ダイアログ表示
     fd,検索情報
    RET,TRUE:OK,FALSE:Cancel                                                */
gboolean
find_dialog (FindString *fd);


G_END_DECLS


#endif /* __FIND_H__ */
