/*
    Text maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __PROPERTY_H__
#define __PROPERTY_H__


#include "tmaid.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:プロパティ関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:プロパティをコピーする
    ft_dst,コピー先
    ft_src,コピー元                                                         */
void
property_copy (FileType *ft_dst,
               FileType *ft_src);


/*  ja:プロパティを変更する
    tmaid,ウインドウ情報
       ft,ファイルタイプ                                                    */
void
property_change (TmaidWindow *tmaid,
                 FileType    *ft);


/******************************************************************************
*                                                                             *
* ja:プロパティダイアログ関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:プロパティダイアログ表示
    parent,親ウインドウ
        ft,ファイルタイプ
       RET,TRUE:OK,FALSE:Cancel                                             */
gboolean
property_dialog (GtkWindow *parent,
                 FileType  *ft);


G_END_DECLS


#endif /* __PROPERTY_H__ */
